/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.impl.engine.processor.AbstractAttributableProcessor;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.StringUtil;

public class AttributeProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -8399232805371906530L;
    private PrefixAwareName _name;
    private ProcessorProperty _value;

    protected AbstractAttributableProcessor findParentAttributable() {
        ProcessorTreeWalker parent = this.getParentProcessor();
        while (parent != null) {
            if (parent instanceof AbstractAttributableProcessor) {
                return (AbstractAttributableProcessor)parent;
            }
            parent = parent.getParentProcessor();
        }
        throw new IllegalStateException();
    }

    public void setName(PrefixAwareName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    protected PrefixAwareName getName() {
        return this._name;
    }

    public void setValue(ProcessorProperty value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this._value = value;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value == null) {
            throw new IllegalStateException();
        }
        AbstractAttributableProcessor parent = this.findParentAttributable();
        parent.addProcesstimeProperty(new ProcessorPropertyWrapper(this._name, this._value));
        return ProcessStatus.SKIP_BODY;
    }

    protected class ProcessorPropertyWrapper
    implements ProcessorProperty {
        private PrefixAwareName _attrName;
        private ProcessorProperty _attrValue;
        private CompiledScript _script;

        public ProcessorPropertyWrapper(PrefixAwareName name, ProcessorProperty property) {
            if (name == null || property == null) {
                throw new IllegalArgumentException();
            }
            this._attrName = name;
            this._attrValue = property;
            this._script = this._attrValue.getValue().isLiteral() ? new EscapedLiteralScript(this._attrValue.getValue()) : new EscapableScript(this._attrValue.getValue());
        }

        public PrefixAwareName getName() {
            return this._attrName;
        }

        public CompiledScript getValue() {
            return this._script;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessorProperty) {
                PrefixAwareName otherName = ((ProcessorProperty)obj).getName();
                return this.getName().getQName().equals(otherName.getQName());
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getName().toString()) + "=\"" + this._script + "\"";
        }
    }

    protected class EscapableScript
    extends ScriptWrapper {
        private static final long serialVersionUID = -5393294025521796857L;

        public EscapableScript(CompiledScript script) {
            super(script);
        }

        public Object execute(Object[] args) {
            Object result = super.execute(args);
            if (this._string && StringUtil.hasValue((String)result)) {
                result = this.escape((String)result);
            }
            return result;
        }
    }

    protected class EscapedLiteralScript
    extends ScriptWrapper {
        private static final long serialVersionUID = -441522603771461865L;
        protected String _escapedValue = (String)super.execute(null);

        public EscapedLiteralScript(CompiledScript script) {
            super(script);
            if (this._string && StringUtil.hasValue(this._escapedValue)) {
                this._escapedValue = this.escape(this._escapedValue);
            }
        }

        public Object execute(Object[] args) {
            return this._escapedValue;
        }
    }

    protected abstract class ScriptWrapper
    implements CompiledScript {
        protected CompiledScript _script;
        protected boolean _string;
        static /* synthetic */ Class class$0;

        public ScriptWrapper(CompiledScript script) {
            this._script = script;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._string = clazz.equals(this._script.getExpectedClass());
        }

        public void setExpectedClass(Class expectedClass) {
            this._script.setExpectedClass(expectedClass);
        }

        public Class getExpectedClass() {
            return this._script.getExpectedClass();
        }

        public Object execute(Object[] args) {
            return this._script.execute(args);
        }

        public void setMethodArgClasses(Class[] methodArgClasses) {
            this._script.setMethodArgClasses(methodArgClasses);
        }

        public Class[] getMethodArgClasses() {
            return this._script.getMethodArgClasses();
        }

        public boolean isLiteral() {
            return this._script.isLiteral();
        }

        public String getScriptText() {
            return this._script.getScriptText();
        }

        public boolean isReadOnly() {
            return this._script.isReadOnly();
        }

        public void assignValue(Object value) {
            this._script.assignValue(value);
        }

        public String toString() {
            return this._script.toString();
        }

        public String escape(String value) {
            return StringUtil.escapeWhitespace(StringUtil.escapeXml(value));
        }
    }
}

