/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.StringUtil;

public class DOCTYPEProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = 8518993579074245108L;
    private String _name;
    private String _publicID;
    private String _systemID;

    public void setName(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setPublicID(String publicID) {
        this._publicID = publicID;
    }

    public String getPublicID() {
        return this._publicID;
    }

    public void setSystemID(String systemID) {
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        StringBuffer docTypeDecl = new StringBuffer(128);
        docTypeDecl.append("<!DOCTYPE ").append(this._name);
        if (StringUtil.hasValue(this._publicID)) {
            docTypeDecl.append(" PUBLIC \"").append(this._publicID).append("\"");
        }
        if (StringUtil.hasValue(this._systemID)) {
            docTypeDecl.append(" \"").append(this._systemID).append("\"");
        }
        docTypeDecl.append(">");
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(docTypeDecl.toString());
        return ProcessStatus.SKIP_BODY;
    }
}

