/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import java.util.Iterator;
import org.cyberneko.html.HTMLElements;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.processor.AbstractAttributableProcessor;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;

public class ElementProcessor
extends AbstractAttributableProcessor
implements CONST_IMPL {
    private static final long serialVersionUID = 923306412062075314L;
    private static final String SUFFIX_DUPLICATED = "_d";
    private PrefixAwareName _name;
    private boolean _duplicated;
    private ThreadLocal _currentNS = new ThreadLocal();
    static /* synthetic */ Class class$0;

    protected void clearCurrentNS() {
        this._currentNS.set(null);
    }

    protected Namespace getCurrentNS() {
        Namespace currentNS = (Namespace)this._currentNS.get();
        if (currentNS == null) {
            currentNS = SpecificationUtil.createNamespace();
            currentNS.setParentSpace(this.getOriginalNode().getParentSpace());
            this._currentNS.set(currentNS);
        }
        return currentNS;
    }

    public void setDuplicated(boolean duplicated) {
        this._duplicated = duplicated;
    }

    public boolean isDuplicated() {
        return this._duplicated;
    }

    public void setName(PrefixAwareName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    protected PrefixAwareName getName() {
        if (this._name == null) {
            throw new IllegalStateException();
        }
        return this._name;
    }

    public String getUniqueID() {
        String uniqueID = super.getUniqueID();
        if (this.isDuplicated()) {
            uniqueID = String.valueOf(uniqueID) + SUFFIX_DUPLICATED;
        }
        return uniqueID;
    }

    public Class getExpectedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void resolvePrefix(PrefixAwareName name) {
        String namespaceURI;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Namespace currentNS = this.getCurrentNS();
        PrefixMapping mapping = currentNS.getMappingFromURI(namespaceURI = name.getQName().getNamespaceURI(), true);
        if (mapping != null) {
            return;
        }
        Namespace namespace = this.getInjectedNode().getParentSpace();
        mapping = namespace.getMappingFromURI(namespaceURI, true);
        if (mapping != null) {
            currentNS.addPrefixMapping(mapping.getPrefix(), mapping.getNamespaceURI());
            return;
        }
        currentNS.addPrefixMapping(name.getPrefix(), namespaceURI);
    }

    protected void resolvePrefixAll() {
        ProcessorProperty prop;
        this.resolvePrefix(this.getName());
        Iterator it = this.iterateProcesstimeProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.resolvePrefix(prop.getName());
        }
        it = this.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.resolvePrefix(prop.getName());
        }
    }

    protected String getResolvedPrefix(PrefixAwareName name) {
        String namespaceURI;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Namespace currentNS = this.getCurrentNS();
        PrefixMapping mapping = currentNS.getMappingFromURI(namespaceURI = name.getQName().getNamespaceURI(), true);
        if (mapping != null) {
            return mapping.getPrefix();
        }
        throw new IllegalStateException();
    }

    protected void appendPrefixMappingString(StringBuffer buffer, Namespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = namespace.iteratePrefixMapping(false);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            String pre = mapping.getPrefix();
            String uri = mapping.getNamespaceURI();
            if (StringUtil.hasValue(pre)) {
                buffer.append(" xmlns:").append(pre);
            } else {
                buffer.append(" xmlns");
            }
            buffer.append("=\"").append(uri).append("\"");
        }
    }

    protected void appendAttributeString(StringBuffer buffer, PrefixAwareName propName, Object value) {
        QName qName = propName.getQName();
        if ("http://maya.seasar.org".equals(qName.getNamespaceURI())) {
            return;
        }
        buffer.append(" ");
        String attrPrefix = this.getResolvedPrefix(propName);
        if (StringUtil.hasValue(attrPrefix)) {
            buffer.append(attrPrefix).append(":");
        }
        buffer.append(qName.getLocalName());
        buffer.append("=\"");
        if (value instanceof CompiledScript) {
            CompiledScript script = (CompiledScript)value;
            buffer.append(script.execute(null));
        } else {
            buffer.append(value.toString());
        }
        buffer.append("\"");
    }

    protected boolean isHTML(QName qName) {
        String namespaceURI = qName.getNamespaceURI();
        return "http://www.w3.org/TR/html4".equals(namespaceURI);
    }

    protected boolean needsCloseElement(QName qName) {
        if (this.isHTML(qName)) {
            String localName = qName.getLocalName();
            HTMLElements.Element element = HTMLElements.getElement((String)localName);
            return !element.isEmpty();
        }
        return this.getChildProcessorSize() > 0;
    }

    protected void write(StringBuffer buffer) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(buffer.toString());
    }

    protected PrefixAwareName getIDName() {
        String namespaceURI = this.getName().getQName().getNamespaceURI();
        PrefixAwareName name = SpecificationUtil.createPrefixAwareName(SpecificationUtil.createQName(namespaceURI, "id"));
        name.setParentSpace(this.getName().getParentSpace());
        return name;
    }

    protected ProcessStatus writeStartElement() {
        ProcessorProperty prop;
        if (this.getName() == null) {
            throw new IllegalStateException();
        }
        this.resolvePrefixAll();
        StringBuffer buffer = new StringBuffer("<");
        String prefix = this.getResolvedPrefix(this.getName());
        if (StringUtil.hasValue(prefix)) {
            buffer.append(prefix).append(":");
        }
        QName qName = this.getName().getQName();
        String uri = qName.getNamespaceURI();
        buffer.append(qName.getLocalName());
        if (!this.isHTML(qName)) {
            this.appendPrefixMappingString(buffer, this.getCurrentNS());
            this.appendPrefixMappingString(buffer, this.getName().getParentSpace());
        }
        Iterator it = this.iterateProcesstimeProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            PrefixAwareName propName = prop.getName();
            QName propQName = propName.getQName();
            String propURI = propQName.getNamespaceURI();
            String propLocalName = propQName.getLocalName();
            if (this.isDuplicated() && uri.equals(propURI) && "id".equals(propLocalName)) continue;
            this.appendAttributeString(buffer, propName, prop.getValue());
        }
        it = this.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            if (this.hasProcesstimeProperty(prop)) continue;
            this.appendAttributeString(buffer, prop.getName(), prop.getValue());
        }
        if (this.isHTML(qName) || this.getChildProcessorSize() > 0) {
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        this.write(buffer);
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    protected void writeEndElement() {
        if (this.getName() == null) {
            throw new IllegalStateException();
        }
        QName qName = this.getName().getQName();
        if (this.needsCloseElement(qName)) {
            StringBuffer buffer = new StringBuffer("</");
            String prefix = this.getResolvedPrefix(this.getName());
            if (StringUtil.hasValue(prefix)) {
                buffer.append(prefix).append(":");
            }
            buffer.append(qName.getLocalName()).append(">");
            this.write(buffer);
        }
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        this.clearCurrentNS();
        return super.doStartProcess(topLevelPage);
    }
}

