/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.engine.Engine;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.TemplateRenderer;
import org.seasar.maya.engine.processor.InformalPropertyAcceptable;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.processor.TemplateProcessor;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.RenderNotCompletedException;
import org.seasar.maya.impl.engine.RenderUtil;
import org.seasar.maya.impl.engine.processor.DoRenderNotFoundException;
import org.seasar.maya.impl.engine.processor.DoRenderProcessor;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class InsertProcessor
extends TemplateProcessorSupport
implements CONST_IMPL,
InformalPropertyAcceptable,
TemplateRenderer {
    private static final long serialVersionUID = -1240398725406503403L;
    private String _path;
    private String _name;
    private SoftReference _page;
    private String _suffix;
    private String _extension;
    private List _attributes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setPath(String path) {
        this._path = path;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addInformalProperty(PrefixAwareName name, Object attr) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(attr);
    }

    public Class getPropertyClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.engine.processor.ProcessorProperty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getExpectedClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public List getInformalProperties() {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        return this._attributes;
    }

    protected Page getPage() {
        Page page = null;
        if (this._page != null && (page = (Page)this._page.get()) == null) {
            this._page = null;
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preparePage() {
        if (StringUtil.hasValue(this._path)) {
            InsertProcessor insertProcessor = this;
            synchronized (insertProcessor) {
                Page page = this.getPage();
                if (page == null) {
                    Engine engine = ProviderUtil.getEngine();
                    String suffixSeparator = engine.getParameter("suffixSeparator");
                    String[] pagePath = StringUtil.parsePath(this._path, suffixSeparator);
                    page = engine.getPage(pagePath[0]);
                    this._page = new SoftReference<Page>(page);
                    this._suffix = pagePath[1];
                    this._extension = pagePath[2];
                }
            }
        }
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        Response response;
        this.preparePage();
        Page renderPage = this.getPage();
        String requestedSuffix = this._suffix;
        String extension = this._extension;
        boolean fireEvent = true;
        if (renderPage == null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            renderPage = topLevelPage;
            RequestScope request = cycle.getRequestScope();
            requestedSuffix = request.getRequestedSuffix();
            extension = request.getExtension();
            fireEvent = false;
        }
        if (renderPage == null) {
            throw new IllegalStateException();
        }
        ProcessStatus ret = RenderUtil.renderPage(fireEvent, this, this.getVariables(), renderPage, requestedSuffix, extension);
        if (ret == null && !(response = CycleUtil.getResponse()).getWriter().isDirty()) {
            throw new RenderNotCompletedException(renderPage.getPageName(), extension);
        }
        if (ret == ProcessStatus.EVAL_PAGE) {
            ret = ProcessStatus.SKIP_BODY;
        }
        return ret;
    }

    protected DoRenderProcessor findDoRender(ProcessorTreeWalker proc, String name) {
        DoRenderProcessor doRender = null;
        int i = 0;
        while (i < proc.getChildProcessorSize()) {
            ProcessorTreeWalker child = proc.getChildProcessor(i);
            if (child instanceof DoRenderProcessor) {
                doRender = (DoRenderProcessor)child;
                if (StringUtil.isEmpty(name) || name.equals(doRender.getName())) break;
            }
            if ((doRender = this.findDoRender(child, name)) != null) break;
            ++i;
        }
        return doRender;
    }

    protected DoRenderProcessor findDoRender(Template[] templates, String name) {
        int i = templates.length - 1;
        while (i >= 0) {
            DoRenderProcessor doRender = this.findDoRender(templates[i], name);
            if (doRender != null) {
                return doRender;
            }
            --i;
        }
        return null;
    }

    protected TemplateProcessor getRenderRoot(DoRenderProcessor doRender) {
        if (!doRender.isReplace()) {
            ProcessorTreeWalker duplecated = doRender.getParentProcessor();
            if (duplecated == null || !(duplecated instanceof TemplateProcessor)) {
                throw new IllegalStateException();
            }
            return (TemplateProcessor)duplecated;
        }
        return doRender;
    }

    public ProcessStatus renderTemplate(Page topLevelPage, Template[] templates) {
        if (topLevelPage == null || templates == null || templates.length == 0) {
            throw new IllegalArgumentException();
        }
        DoRenderProcessor doRender = this.findDoRender(templates, this._name);
        if (doRender == null) {
            throw new DoRenderNotFoundException(this._name);
        }
        TemplateProcessor insertRoot = this.getRenderRoot(doRender);
        doRender.pushInsertProcessor(this);
        ProcessStatus ret = RenderUtil.renderTemplateProcessor(topLevelPage, insertRoot);
        doRender.popInsertProcessor();
        return ret;
    }
}

