/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.StringUtil;

public class ProcessingInstructionProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = 6717263251948534639L;
    private String _target;
    private String _data;

    public void setTarget(String target) {
        if (StringUtil.isEmpty(target)) {
            throw new IllegalArgumentException();
        }
        this._target = target;
    }

    public String getTarget() {
        return this._target;
    }

    public void setData(String data) {
        this._data = data;
    }

    public String getData() {
        return this._data;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        StringBuffer processingInstruction = new StringBuffer(128);
        processingInstruction.append("<?").append(this._target);
        if (StringUtil.hasValue(this._data)) {
            processingInstruction.append(" ").append(this._data);
        }
        processingInstruction.append("?>\r\n");
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(processingInstruction.toString());
        return ProcessStatus.SKIP_BODY;
    }
}

