/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.processor.TemplateProcessor;
import org.seasar.maya.engine.specification.SpecificationNode;

public class TemplateProcessorSupport
implements TemplateProcessor {
    private static final long serialVersionUID = -3521980479718620027L;
    private static final String PREFIX_UNIQUE_ID = "_m";
    private ProcessorTreeWalker _parent;
    private int _index;
    private List _children = new ArrayList();
    private SpecificationNode _originalNode;
    private SpecificationNode _injectedNode;
    private boolean _evalBodyInclude = true;
    private ProcessorDefinition _definition;

    public String getUniqueID() {
        int sequenceID = this.getOriginalNode().getSequenceID();
        return PREFIX_UNIQUE_ID + sequenceID;
    }

    public void setEvalBodyInclude(boolean evalBodyInclude) {
        this._evalBodyInclude = evalBodyInclude;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._evalBodyInclude) {
            return ProcessStatus.EVAL_BODY_INCLUDE;
        }
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessStatus doEndProcess() {
        return ProcessStatus.EVAL_PAGE;
    }

    public void setOriginalNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this._originalNode = node;
    }

    public SpecificationNode getOriginalNode() {
        if (this._originalNode == null) {
            throw new IllegalArgumentException();
        }
        return this._originalNode;
    }

    public void setInjectedNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this._injectedNode = node;
    }

    public SpecificationNode getInjectedNode() {
        if (this._injectedNode == null) {
            throw new IllegalStateException();
        }
        return this._injectedNode;
    }

    public void setProcessorDefinition(ProcessorDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this._definition = definition;
    }

    public ProcessorDefinition getProcessorDefinition() {
        if (this._definition == null) {
            throw new IllegalStateException();
        }
        return this._definition;
    }

    public Map getVariables() {
        return null;
    }

    public void setParentProcessor(ProcessorTreeWalker parent, int index) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parent;
        this._index = index;
    }

    public ProcessorTreeWalker getParentProcessor() {
        return this._parent;
    }

    public int getIndex() {
        return this._index;
    }

    public void addChildProcessor(ProcessorTreeWalker child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        this._children.add(child);
        child.setParentProcessor(this, this._children.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildProcessorSize() {
        List list = this._children;
        synchronized (list) {
            return this._children.size();
        }
    }

    public ProcessorTreeWalker getChildProcessor(int index) {
        return (ProcessorTreeWalker)this._children.get(index);
    }
}

