/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class WriteProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -8069702863937020350L;
    private ProcessorProperty _value;
    private ProcessorProperty _default;
    private ProcessorProperty _escapeXml;
    private ProcessorProperty _escapeWhitespace;

    public void setValue(ProcessorProperty value) {
        this._value = value;
    }

    public void setDefault(ProcessorProperty defaultValue) {
        this._default = defaultValue;
    }

    public void setEscapeXml(ProcessorProperty escapeXml) {
        this._escapeXml = escapeXml;
    }

    public void setEscapeWhitespace(ProcessorProperty escapeWhitespace) {
        this._escapeWhitespace = escapeWhitespace;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value != null) {
            boolean escapeWhitespace;
            boolean escapeXml;
            String ret = (String)this._value.getValue().execute(null);
            if (StringUtil.isEmpty(ret) && this._default != null) {
                ret = (String)this._default.getValue().execute(null);
            }
            if (this._escapeXml != null && (escapeXml = ObjectUtil.booleanValue(this._escapeXml.getValue().execute(null), false))) {
                ret = StringUtil.escapeXml(ret);
            }
            if (this._escapeWhitespace != null && (escapeWhitespace = ObjectUtil.booleanValue(this._escapeWhitespace.getValue().execute(null), false))) {
                ret = StringUtil.escapeWhitespace(ret);
            }
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            cycle.getResponse().write(ret);
        }
        return ProcessStatus.SKIP_BODY;
    }
}

