/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.impl.engine.specification.PrefixMappingImpl;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class NamespaceImpl
implements Namespace {
    private static Log LOG;
    private Namespace _parentSpace;
    private List _mappings;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.specification.NamespaceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setParentSpace(Namespace parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this._parentSpace = parent;
    }

    public Namespace getParentSpace() {
        return this._parentSpace;
    }

    protected PrefixMapping createPrefixMapping(String prefix, String namespaceURI) {
        return new PrefixMappingImpl(prefix, namespaceURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrefixMapping(String prefix, String namespaceURI) {
        if (prefix == null || StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        NamespaceImpl namespaceImpl = this;
        synchronized (namespaceImpl) {
            PrefixMapping mapping;
            if (this._mappings == null) {
                this._mappings = new ArrayList();
            }
            if (!this._mappings.contains(mapping = this.createPrefixMapping(prefix, namespaceURI))) {
                this._mappings.add(mapping);
                mapping.setNamespace(this);
            } else if (LOG.isWarnEnabled()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.specification.NamespaceImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                LOG.warn((Object)StringUtil.getMessage((Class)clazz, 0, mapping.toString()));
            }
        }
    }

    protected PrefixMapping getMapping(boolean fromPrefix, String test, boolean all) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = this.iteratePrefixMapping(all);
        while (it.hasNext()) {
            String value;
            PrefixMapping mapping = (PrefixMapping)it.next();
            String string = value = fromPrefix ? mapping.getPrefix() : mapping.getNamespaceURI();
            if (!test.equals(value)) continue;
            return mapping;
        }
        return null;
    }

    public PrefixMapping getMappingFromPrefix(String prefix, boolean all) {
        if (prefix == null) {
            prefix = "";
        }
        return this.getMapping(true, prefix, all);
    }

    public PrefixMapping getMappingFromURI(String namespaceURI, boolean all) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        return this.getMapping(false, namespaceURI, all);
    }

    public Iterator iteratePrefixMapping(boolean all) {
        if (all && this.getParentSpace() != null) {
            return new AllNamespaceIterator(this);
        }
        if (this._mappings != null) {
            return this._mappings.iterator();
        }
        return NullIterator.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addedMapping() {
        if (this._mappings == null) {
            return false;
        }
        List list = this._mappings;
        synchronized (list) {
            return this._mappings.size() > 0;
        }
    }

    protected class AllNamespaceIterator
    implements Iterator {
        private Namespace _current;
        private Iterator _it;

        public AllNamespaceIterator(Namespace current) {
            if (current == null) {
                throw new IllegalArgumentException();
            }
            this._current = current;
            this._it = current.iteratePrefixMapping(false);
        }

        public boolean hasNext() {
            while (this._it != null) {
                boolean ret = this._it.hasNext();
                if (ret) {
                    return true;
                }
                this._current = this._current.getParentSpace();
                this._it = this._current != null ? this._current.iteratePrefixMapping(false) : null;
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                return this._it.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

