/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.util.Iterator;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.util.collection.NullIterator;

public class NodeAttributeImpl
implements NodeAttribute {
    private SpecificationNode _node;
    private QName _qName;
    private String _value;

    public NodeAttributeImpl(QName qName, String value) {
        if (qName == null || value == null) {
            throw new IllegalArgumentException();
        }
        this._qName = qName;
        this._value = value;
    }

    public void setNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this._node = node;
    }

    public SpecificationNode getNode() {
        return this._node;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this.getQName().toString();
    }

    public QName getQName() {
        return this._qName;
    }

    public String getPrefix() {
        String namespaceURI = this.getQName().getNamespaceURI();
        PrefixMapping mapping = this.getMappingFromURI(namespaceURI, true);
        if (mapping != null) {
            return mapping.getPrefix();
        }
        return "";
    }

    public void setParentSpace(Namespace parent) {
        throw new UnsupportedOperationException();
    }

    public Namespace getParentSpace() {
        if (this.getNode() != null) {
            return this.getNode().getParentSpace();
        }
        return null;
    }

    public void addPrefixMapping(String prefix, String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public PrefixMapping getMappingFromPrefix(String prefix, boolean all) {
        if (this.getNode() != null) {
            return this.getNode().getMappingFromPrefix(prefix, all);
        }
        return null;
    }

    public PrefixMapping getMappingFromURI(String namespaceURI, boolean all) {
        if (this.getNode() != null) {
            return this.getNode().getMappingFromURI(namespaceURI, all);
        }
        return null;
    }

    public Iterator iteratePrefixMapping(boolean all) {
        if (this.getNode() != null) {
            return this.getNode().iteratePrefixMapping(all);
        }
        return NullIterator.getInstance();
    }

    public boolean addedMapping() {
        return false;
    }
}

