/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.util.Iterator;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.impl.engine.specification.NamespaceImpl;
import org.seasar.maya.impl.util.StringUtil;

public class PrefixAwareNameImpl
extends NamespaceImpl
implements PrefixAwareName {
    private QName _qName;

    public PrefixAwareNameImpl(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        this._qName = qName;
    }

    public QName getQName() {
        return this._qName;
    }

    public String getPrefix() {
        String namespaceURI = this.getQName().getNamespaceURI();
        Iterator it = this.iteratePrefixMapping(true);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            if (!namespaceURI.equals(mapping.getNamespaceURI())) continue;
            return mapping.getPrefix();
        }
        return "";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String prefix = this.getPrefix();
        if (StringUtil.hasValue(prefix)) {
            buffer.append(prefix).append(":");
        }
        buffer.append(this.getQName().getLocalName());
        return buffer.toString();
    }

    public boolean equals(Object test) {
        return this.getQName().equals(test);
    }
}

