/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.impl.util.StringUtil;

public class PrefixMappingImpl
implements PrefixMapping {
    private Namespace _namespace;
    private String _prefix;
    private String _namespaceURI;

    public PrefixMappingImpl(String prefix, String namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            prefix = "";
        }
        this._prefix = prefix;
        this._namespaceURI = namespaceURI;
    }

    public void setNamespace(Namespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this._namespace = namespace;
    }

    public Namespace getNamespace() {
        if (this._namespace == null) {
            throw new IllegalStateException();
        }
        return this._namespace;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("xmlns");
        if (StringUtil.hasValue(this.getPrefix())) {
            buffer.append(":").append(this.getPrefix());
        }
        buffer.append("=").append(this.getNamespaceURI());
        return buffer.toString();
    }

    public boolean equals(Object test) {
        if (test == null || !(test instanceof PrefixMapping)) {
            return false;
        }
        PrefixMappingImpl ns = (PrefixMappingImpl)test;
        return this.getPrefix().equals(ns.getPrefix()) && this.getNamespaceURI().equals(ns.getNamespaceURI());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

