/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.seasar.maya.builder.SpecificationBuilder;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.source.NullSourceDescriptor;
import org.seasar.maya.impl.util.collection.NullIterator;
import org.seasar.maya.source.SourceDescriptor;

public class SpecificationImpl
extends ParameterAwareImpl
implements Specification,
CONST_IMPL {
    private static final long serialVersionUID = 174451168836001746L;
    private Date _buildTimestamp;
    private SourceDescriptor _source;
    private List _childNodes;
    private boolean _hasSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        SpecificationImpl specificationImpl = this;
        synchronized (specificationImpl) {
            if (this._childNodes != null) {
                this._childNodes.clear();
            }
        }
    }

    protected boolean checkTimestamp() {
        return EngineUtil.getEngineSettingBoolean("checkTimestamp", true);
    }

    protected boolean isSourceNotExists() {
        if (!this.checkTimestamp()) {
            return false;
        }
        return !this.getSource().exists();
    }

    protected boolean isOldSpecification() {
        if (!this.checkTimestamp()) {
            return false;
        }
        if (this._hasSource != this.getSource().exists()) {
            this.clear();
            this.kill();
            this._hasSource = this.getSource().exists();
            return true;
        }
        if (this.getTimestamp() == null) {
            return true;
        }
        Date source = this.getSource().getTimestamp();
        Date now = new Date();
        return source.after(this.getTimestamp()) && now.after(source);
    }

    protected void parseSpecification() {
        this.setTimestamp(new Date());
        if (this.getSource().exists()) {
            this.clear();
            SpecificationBuilder builder = ProviderUtil.getSpecificationBuilder();
            builder.build(this);
        }
    }

    protected void setTimestamp(Date buildTimestamp) {
        this._buildTimestamp = buildTimestamp;
    }

    public Date getTimestamp() {
        return this._buildTimestamp;
    }

    public void setSource(SourceDescriptor source) {
        this._source = source;
    }

    public SourceDescriptor getSource() {
        if (this._source == null) {
            this._source = new NullSourceDescriptor();
        }
        return this._source;
    }

    public void kill() {
        this.setTimestamp(null);
    }

    public void setParentNode(NodeTreeWalker parentNode) {
        throw new IllegalStateException();
    }

    public NodeTreeWalker getParentNode() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNode(NodeTreeWalker childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException();
        }
        Object object = this;
        synchronized (object) {
            if (this._childNodes == null) {
                this._childNodes = new ArrayList();
            }
        }
        object = this._childNodes;
        synchronized (object) {
            this._childNodes.add(childNode);
            childNode.setParentNode(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateChildNode() {
        SpecificationImpl specificationImpl = this;
        synchronized (specificationImpl) {
            if (this.isOldSpecification()) {
                this.parseSpecification();
            }
        }
        if (this._childNodes == null) {
            return NullIterator.getInstance();
        }
        return this._childNodes.iterator();
    }

    public String getSystemID() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getSystemID();
    }

    public int getLineNumber() {
        return 0;
    }

    public boolean isOnTemplate() {
        return false;
    }

    protected class ChildSpecificationsIterator
    implements Iterator {
        private int _index;
        private Specification _next;
        private List _list;

        public ChildSpecificationsIterator(List list) {
            if (list == null) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._index = list.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this._next == null) ** GOTO lbl17
            return true;
lbl-1000:
            // 1 sources

            {
                --this._index;
                if (this._index < 0) {
                    return false;
                }
                var1_1 = this._list;
                synchronized (var1_1) {
                    ref = (SoftReference)this._list.get(this._index);
                    this._next = (Specification)ref.get();
                    if (this._next == null) {
                        this._list.remove(this._index);
                    }
                    continue;
                }
lbl17:
                // 2 sources

                ** while (this._next == null)
            }
lbl18:
            // 1 sources

            return true;
        }

        public Object next() {
            if (this._next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Specification ret = this._next;
            this._next = null;
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

