/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.maya.engine.specification.CopyToFilter;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.NodeObject;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.engine.specification.NodeAttributeImpl;
import org.seasar.maya.impl.engine.specification.PrefixAwareNameImpl;
import org.seasar.maya.impl.util.collection.NullIterator;

public class SpecificationNodeImpl
extends PrefixAwareNameImpl
implements SpecificationNode,
CONST_IMPL {
    private static final CopyToFilter FILTER_ALL = new AllCopyToFilter();
    private int _sequenceID = -1;
    private Map _attributes;
    private NodeTreeWalker _parent;
    private List _childNodes;
    private String _systemID;
    private int _lineNumber;
    private boolean _onTemplate;

    public SpecificationNodeImpl(QName qName) {
        super(qName);
    }

    public void setSequenceID(int sequenceID) {
        if (sequenceID < 0) {
            throw new IllegalArgumentException();
        }
        this._sequenceID = sequenceID;
    }

    public int getSequenceID() {
        if (this._sequenceID < 0) {
            throw new IllegalStateException();
        }
        return this._sequenceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(QName qName, String value) {
        if (qName == null || value == null) {
            throw new IllegalArgumentException();
        }
        Object object = this;
        synchronized (object) {
            if (this._attributes == null) {
                this._attributes = new HashMap();
            }
        }
        object = this._attributes;
        synchronized (object) {
            if (!this._attributes.containsKey(qName)) {
                NodeAttributeImpl attr = new NodeAttributeImpl(qName, value);
                this._attributes.put(qName, attr);
                attr.setNode(this);
            }
        }
    }

    public NodeAttribute getAttribute(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        if (this._attributes == null) {
            return null;
        }
        return (NodeAttribute)this._attributes.get(qName);
    }

    public Iterator iterateAttribute() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.values().iterator();
    }

    public SpecificationNode copyTo(CopyToFilter filter) {
        SpecificationNodeImpl copy = new SpecificationNodeImpl(this.getQName());
        copy.setSequenceID(this.getSequenceID());
        copy.setSystemID(this.getSystemID());
        copy.setLineNumber(this.getLineNumber());
        copy.setOnTemplate(this.isOnTemplate());
        Iterator it = this.iterateAttribute();
        while (it.hasNext()) {
            NodeAttribute attr = (NodeAttribute)it.next();
            if (!filter.accept(attr)) continue;
            copy.addAttribute(attr.getQName(), attr.getValue());
        }
        it = this.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode node = (SpecificationNode)it.next();
            if (!filter.accept(node)) continue;
            copy.addChildNode(node.copyTo(filter));
        }
        copy.setParentSpace(this.getParentSpace());
        return copy;
    }

    public SpecificationNode copyTo() {
        return this.copyTo(FILTER_ALL);
    }

    public String toString() {
        StringBuffer path = new StringBuffer();
        if (this.getParentNode() != null && !(this.getParentNode() instanceof Specification)) {
            path.append(this.getParentNode());
        }
        path.append("/");
        path.append(super.toString());
        return path.toString();
    }

    public void setParentNode(NodeTreeWalker parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parent;
    }

    public NodeTreeWalker getParentNode() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNode(NodeTreeWalker child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        Object object = this;
        synchronized (object) {
            if (this._childNodes == null) {
                this._childNodes = new ArrayList();
            }
        }
        object = this._childNodes;
        synchronized (object) {
            this._childNodes.add(child);
            child.setParentNode(this);
        }
    }

    public Iterator iterateChildNode() {
        if (this._childNodes == null) {
            return NullIterator.getInstance();
        }
        return this._childNodes.iterator();
    }

    public void setSystemID(String systemID) {
        if (systemID == null) {
            throw new IllegalArgumentException();
        }
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setOnTemplate(boolean onTemplate) {
        this._onTemplate = onTemplate;
    }

    public boolean isOnTemplate() {
        return this._onTemplate;
    }

    protected static class AllCopyToFilter
    implements CopyToFilter {
        protected AllCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            return true;
        }
    }
}

