/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification.xpath;

import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.util.SingleObjectIterator;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.PrefixMapping;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.engine.specification.xpath.SpecificationXPath;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.AbstractScanningIterator;
import org.seasar.maya.impl.util.collection.NullIterator;

public class SpecificationNavigator
extends DefaultNavigator
implements NamedAccessNavigator,
CONST_IMPL {
    private static final long serialVersionUID = -8845415744894196361L;
    private static final Navigator _instance = new SpecificationNavigator();

    public static Navigator getInstance() {
        return _instance;
    }

    protected SpecificationNavigator() {
    }

    protected String getNamespaceURI(Namespace namespace, String prefix) {
        PrefixMapping mapping;
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((mapping = namespace.getMappingFromPrefix(prefix, true)) != null) {
            return mapping.getNamespaceURI();
        }
        return null;
    }

    public Iterator getParentAxisIterator(Object obj) {
        Object parent = null;
        if (obj instanceof PrefixMapping) {
            parent = ((PrefixMapping)obj).getNamespace();
        } else if (obj instanceof NodeAttribute) {
            parent = ((NodeAttribute)obj).getNode();
        } else if (obj instanceof NodeTreeWalker) {
            parent = ((NodeTreeWalker)obj).getParentNode();
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return NullIterator.getInstance();
    }

    public Iterator getNamespaceAxisIterator(Object obj) {
        if (obj instanceof Namespace) {
            Namespace namespace = (Namespace)obj;
            return namespace.iteratePrefixMapping(true);
        }
        return NullIterator.getInstance();
    }

    public Iterator getAttributeAxisIterator(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return node.iterateAttribute();
        }
        return NullIterator.getInstance();
    }

    public Iterator getAttributeAxisIterator(Object obj, String localName, String namespacePrefix, String namespaceURI) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            if (StringUtil.isEmpty(namespaceURI)) {
                namespaceURI = this.getNamespaceURI(node, namespacePrefix);
            }
            QName qName = SpecificationUtil.createQName(namespaceURI, localName);
            return new QNameFilteredIterator(qName, node.iterateAttribute());
        }
        return NullIterator.getInstance();
    }

    public Iterator getChildAxisIterator(Object obj) {
        if (obj instanceof NodeTreeWalker) {
            NodeTreeWalker node = (NodeTreeWalker)obj;
            return node.iterateChildNode();
        }
        return NullIterator.getInstance();
    }

    public Iterator getChildAxisIterator(Object obj, String localName, String namespacePrefix, String namespaceURI) {
        if (obj instanceof NodeTreeWalker) {
            NodeTreeWalker node = (NodeTreeWalker)obj;
            if (StringUtil.isEmpty(namespaceURI)) {
                namespaceURI = node instanceof Namespace ? this.getNamespaceURI((Namespace)((Object)node), namespacePrefix) : "http://maya.seasar.org";
            }
            QName qName = SpecificationUtil.createQName(namespaceURI, localName);
            return new QNameFilteredIterator(qName, node.iterateChildNode());
        }
        return NullIterator.getInstance();
    }

    public Object getDocumentNode(Object obj) {
        if (obj instanceof NodeTreeWalker) {
            NodeTreeWalker current = (NodeTreeWalker)obj;
            while (current != null) {
                if (current instanceof Specification) {
                    return current;
                }
                current = current.getParentNode();
            }
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object obj) {
        Namespace namaspace = null;
        if (obj instanceof PrefixMapping) {
            namaspace = ((PrefixMapping)obj).getNamespace();
        } else if (obj instanceof Namespace) {
            namaspace = (Namespace)obj;
        }
        if (namaspace != null) {
            return this.getNamespaceURI(namaspace, prefix);
        }
        return null;
    }

    public String getAttributeName(Object obj) {
        if (obj instanceof NodeAttribute) {
            NodeAttribute attr = (NodeAttribute)obj;
            return attr.getQName().getLocalName();
        }
        return null;
    }

    public String getAttributeNamespaceUri(Object obj) {
        if (obj instanceof NodeAttribute) {
            NodeAttribute attr = (NodeAttribute)obj;
            return attr.getQName().getNamespaceURI();
        }
        return null;
    }

    public String getAttributeQName(Object obj) {
        if (obj instanceof NodeAttribute) {
            NodeAttribute attr = (NodeAttribute)obj;
            String prefix = attr.getPrefix();
            if (StringUtil.hasValue(prefix)) {
                return String.valueOf(prefix) + ":" + this.getAttributeName(obj);
            }
            return this.getAttributeName(obj);
        }
        return null;
    }

    public String getAttributeStringValue(Object obj) {
        if (obj instanceof NodeAttribute) {
            NodeAttribute attr = (NodeAttribute)obj;
            return attr.getValue();
        }
        return null;
    }

    public String getCommentStringValue(Object obj) {
        if (this.isComment(obj)) {
            SpecificationNode node = (SpecificationNode)obj;
            return SpecificationUtil.getAttributeValue(node, QM_TEXT);
        }
        return null;
    }

    public String getElementName(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return node.getQName().getLocalName();
        }
        return null;
    }

    public String getElementNamespaceUri(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return node.getQName().getNamespaceURI();
        }
        return null;
    }

    public String getElementQName(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            String prefix = node.getPrefix();
            if (StringUtil.hasValue(prefix)) {
                return String.valueOf(prefix) + ":" + this.getElementName(obj);
            }
            return this.getElementName(obj);
        }
        return null;
    }

    public String getElementStringValue(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            StringBuffer buffer = new StringBuffer();
            Iterator it = node.iterateChildNode();
            while (it.hasNext()) {
                String value;
                SpecificationNode child = (SpecificationNode)it.next();
                if (!this.isText(child) || (value = this.getTextStringValue(child)) == null) continue;
                buffer.append(value.trim());
            }
            return buffer.toString();
        }
        return null;
    }

    public String getNamespacePrefix(Object obj) {
        if (obj instanceof PrefixMapping) {
            PrefixMapping mapping = (PrefixMapping)obj;
            return mapping.getPrefix();
        }
        return null;
    }

    public String getNamespaceStringValue(Object obj) {
        if (obj instanceof PrefixMapping) {
            PrefixMapping mapping = (PrefixMapping)obj;
            return mapping.getNamespaceURI();
        }
        return null;
    }

    public String getTextStringValue(Object obj) {
        SpecificationNode node;
        String text;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (this.isText(obj) && (text = SpecificationUtil.getAttributeValue(node = (SpecificationNode)obj, QM_TEXT)) != null) {
            return text;
        }
        return "";
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof NodeAttribute;
    }

    public boolean isComment(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return QM_COMMENT.equals(node.getQName());
        }
        return false;
    }

    public boolean isDocument(Object obj) {
        return obj instanceof Specification;
    }

    public boolean isElement(Object obj) {
        return obj instanceof SpecificationNode && !this.isProcessingInstruction(obj) && !this.isText(obj) && !this.isDocType(obj);
    }

    public boolean isNamespace(Object obj) {
        return obj instanceof PrefixMapping;
    }

    public boolean isProcessingInstruction(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return QM_PI.equals(node.getQName());
        }
        return false;
    }

    public boolean isText(Object obj) {
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return QM_CHARACTERS.equals(node.getQName()) || QM_CDATA.equals(node.getQName());
        }
        return false;
    }

    public XPath parseXPath(String xpath) {
        return SpecificationXPath.createXPath(xpath, null);
    }

    public boolean isDocType(Object obj) {
        if (obj instanceof SpecificationNode) {
            SpecificationNode node = (SpecificationNode)obj;
            return QM_DOCTYPE.equals(node.getQName());
        }
        return false;
    }

    protected class QNameFilteredIterator
    extends AbstractScanningIterator {
        private QName _qName;

        public QNameFilteredIterator(QName qName, Iterator iterator) {
            super(iterator);
            if (qName == null) {
                throw new IllegalArgumentException();
            }
            this._qName = qName;
        }

        protected boolean filter(Object test) {
            if (test == null || !(test instanceof PrefixAwareName)) {
                return false;
            }
            PrefixAwareName prefixAwareName = (PrefixAwareName)test;
            return this._qName.equals(prefixAwareName.getQName());
        }
    }
}

