/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cyberneko.html.HTMLEntities;
import org.seasar.maya.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.maya.impl.util.IOUtil;

public final class StringUtil {
    private static Map _propFiles = new HashMap();
    private static String[] ZERO = new String[0];

    private StringUtil() {
    }

    public static boolean isEmpty(String test) {
        return test == null || test.length() == 0;
    }

    public static boolean hasValue(String test) {
        return !StringUtil.isEmpty(test);
    }

    public static String preparePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        path = path.trim();
        if ((path = path.replace(File.separatorChar, '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public static String resolveEntity(String blockString) {
        StringBuffer buffer = new StringBuffer();
        int start = blockString.indexOf("&");
        if (start == -1) {
            return blockString;
        }
        buffer.append(blockString.substring(0, start));
        do {
            int end;
            if ((end = blockString.indexOf(";", start)) == -1) {
                buffer.append(blockString.substring(start));
                break;
            }
            String entity = blockString.substring(start + 1, end);
            int value = HTMLEntities.get((String)entity);
            if (value != -1) {
                buffer.append((char)value);
            } else {
                buffer.append(blockString.substring(start, end + 1));
            }
            start = blockString.indexOf("&", end);
            if (start == -1) {
                buffer.append(blockString.substring(end + 1));
                break;
            }
            if (start == end + 1) continue;
            buffer.append(blockString.substring(end + 1, start));
        } while (start != blockString.length());
        return buffer.toString();
    }

    public static String[] parsePath(String path, String suffixSeparator) {
        int lastDotOffset;
        String[] ret = new String[3];
        int paramOffset = path.indexOf(63);
        if (paramOffset >= 0) {
            path = path.substring(0, paramOffset);
        }
        int lastSlashOffset = path.lastIndexOf(47);
        String folder = "";
        String file = path;
        if (lastSlashOffset >= 0) {
            folder = path.substring(0, lastSlashOffset + 1);
            file = path.substring(lastSlashOffset + 1);
        }
        if ((lastDotOffset = file.lastIndexOf(46)) > 0) {
            ret[2] = file.substring(lastDotOffset + 1);
            file = file.substring(0, lastDotOffset);
        } else {
            ret[2] = "";
        }
        int suffixSeparatorOffset = file.lastIndexOf(suffixSeparator);
        if (suffixSeparatorOffset > 0) {
            ret[0] = String.valueOf(folder) + file.substring(0, suffixSeparatorOffset);
            ret[1] = file.substring(suffixSeparatorOffset + suffixSeparator.length());
        } else {
            ret[0] = String.valueOf(folder) + file;
            ret[1] = "";
        }
        return ret;
    }

    public static String getMessage(Class clazz, int index) {
        return StringUtil.getMessage(clazz, index, ZERO);
    }

    public static String getMessage(Class clazz, int index, String param0) {
        return StringUtil.getMessage(clazz, index, new String[]{param0});
    }

    public static String getMessage(Class clazz, int index, String param0, String param1) {
        return StringUtil.getMessage(clazz, index, new String[]{param0, param1});
    }

    public static String getMessage(Class clazz, int index, String param0, String param1, String param2) {
        return StringUtil.getMessage(clazz, index, new String[]{param0, param1, param2});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getMessage(Class clazz, int index, String[] params) {
        String message;
        String className;
        int pos;
        Properties properties;
        block9: {
            Package key = clazz.getPackage();
            properties = (Properties)_propFiles.get(key);
            if (properties != null) break block9;
            ClassLoaderSourceDescriptor source = new ClassLoaderSourceDescriptor();
            source.setSystemID("message.properties");
            source.setNeighborClass(clazz);
            properties = new Properties();
            _propFiles.put(key, properties);
            if (!source.exists()) break block9;
            InputStream stream = source.getInputStream();
            try {
                try {
                    properties.load(stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                IOUtil.close(stream);
                throw throwable;
            }
            {
                Object var8_12 = null;
            }
            IOUtil.close(stream);
        }
        if ((pos = (className = clazz.getName()).lastIndexOf(46)) != -1) {
            className = className.substring(pos + 1);
        }
        StringBuffer propertyName = new StringBuffer(className);
        if (index > 0) {
            propertyName.append(".").append(index);
        }
        if (StringUtil.isEmpty(message = properties.getProperty(propertyName.toString()))) {
            message = "!" + clazz.getName() + "!";
        }
        if (params == null) {
            params = ZERO;
        }
        return MessageFormat.format(message, params);
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 50);
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&#39;");
                    break;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeWhitespace(String text) {
        if (text == null) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 50);
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\r': {
                    sb.append("&#xd;");
                    break;
                }
                case '\n': {
                    sb.append("&#xa;");
                    break;
                }
                case '\t': {
                    sb.append("&#x9;");
                    break;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

