/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.util.xml;

import org.seasar.maya.impl.builder.parser.AdditionalHandler;
import org.seasar.maya.impl.util.collection.AbstractSoftReferencePool;
import org.seasar.maya.impl.util.xml.AdditionalSAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XMLReaderPool
extends AbstractSoftReferencePool {
    private static final long serialVersionUID = 1736077679163143852L;
    private static XMLReaderPool _xmlReaderPool;

    public static XMLReaderPool getPool() {
        if (_xmlReaderPool == null) {
            _xmlReaderPool = new XMLReaderPool();
        }
        return _xmlReaderPool;
    }

    protected XMLReaderPool() {
    }

    protected Object createObject() {
        AdditionalSAXParser xmlReader = new AdditionalSAXParser();
        return xmlReader;
    }

    protected boolean validateObject(Object object) {
        return object instanceof XMLReader;
    }

    protected void setFeature(XMLReader xmlReader, String name, boolean value) {
        try {
            xmlReader.setFeature(name, value);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    protected void setProperty(XMLReader xmlReader, String name, Object value) {
        try {
            xmlReader.setProperty(name, value);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public XMLReader borrowXMLReader(ContentHandler handler, boolean namespaces, boolean validation, boolean xmlSchema) {
        XMLReader xmlReader = (XMLReader)this.borrowObject();
        this.setFeature(xmlReader, "http://xml.org/sax/features/namespaces", namespaces);
        this.setFeature(xmlReader, "http://xml.org/sax/features/validation", validation);
        this.setFeature(xmlReader, "http://apache.org/xml/features/validation/schema", xmlSchema);
        xmlReader.setContentHandler(handler);
        if (handler instanceof EntityResolver) {
            xmlReader.setEntityResolver((EntityResolver)((Object)handler));
        }
        if (handler instanceof ErrorHandler) {
            xmlReader.setErrorHandler((ErrorHandler)((Object)handler));
        }
        if (handler instanceof DTDHandler) {
            xmlReader.setDTDHandler((DTDHandler)((Object)handler));
        }
        if (handler instanceof LexicalHandler) {
            this.setProperty(xmlReader, "http://xml.org/sax/properties/lexical-handler", handler);
        }
        if (handler instanceof AdditionalHandler) {
            this.setProperty(xmlReader, "org.seasar.maya.impl.builder.parser.AdditionalHandler", handler);
        }
        return xmlReader;
    }

    public void returnXMLReader(XMLReader xmlReader) {
        this.returnObject(xmlReader);
    }
}

