package org.seasar.framework.sel.exps;

import java.lang.reflect.Array;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class NewArrayExp implements Expression {

	private Class clazz_;
	private Expression arraySizeExp_;
	private Expression[] argExps_;

	public NewArrayExp(
		Class clazz,
		Expression arraySizeExp,
		Expression[] argExps) {

		clazz_ = clazz;
		arraySizeExp_ = arraySizeExp;
		argExps_ = argExps;
	}

	public Object evaluateValue(SelContext context) {
		int arraySize =
			((Number) arraySizeExp_.evaluateValue(context)).intValue();
		Object[] array = (Object[]) Array.newInstance(clazz_, arraySize);
		for (int i = 0; i < argExps_.length; ++i) {
			array[i] = argExps_[i].evaluateValue(context);
		}
		return array;
	}
}
