package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

/**
 * @author higa
 *
 */
public class BasicSelectHandler extends BasicHandler implements SelectHandler {

	private static Logger logger_ = Logger.getLogger(BasicSelectHandler.class);
	private ResultSetHandler resultSetHandler_;
	private int fetchSize_ = 100;
	private int maxRows_ = -1;

	public BasicSelectHandler() {
	}

	public BasicSelectHandler(
		DataSource dataSource,
		String sql,
		ResultSetHandler resultSetHandler) {

		setDataSource(dataSource);
		setSql(sql);
		setResultSetHandler(resultSetHandler);
	}

	public ResultSetHandler getResultSetHandler() {
		return resultSetHandler_;
	}

	public void setResultSetHandler(ResultSetHandler resultSetHandler) {
		resultSetHandler_ = resultSetHandler;
	}

	public int getFetchSize() {
		return fetchSize_;
	}

	public void setFetchSize(int fetchSize) {
		fetchSize_ = fetchSize;
	}

	public int getMaxRows() {
		return maxRows_;
	}

	public void setMaxRows(int maxRows) {
		maxRows_ = maxRows;
	}

	/**
	 * @see org.seasar.extension.jdbc.SelectHandler#execute(java.lang.Object[])
	 */
	public Object execute(Object[] args) throws SQLRuntimeException {
		if (logger_.isDebugEnabled()) {
			logger_.debug(getCompleteSql(args));
		}
		Connection connection = getConnection();
		try {
			return execute(connection, args);
		} finally {
			ConnectionUtil.close(connection);
		}
	}

	protected Object execute(Connection connection, Object[] args) {
		DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData(connection);
		PreparedStatement ps = prepareStatement(connection);
		try {
			if (fetchSize_ > -1) {
				StatementUtil.setFetchSize(ps, fetchSize_);
			}
			if (maxRows_ > -1) {
				StatementUtil.setMaxRows(ps, maxRows_);
			}
			bindArgs(ps, args);
			return execute(ps, dbMetaData);
		} finally {
			StatementUtil.close(ps);
		}
	}

	protected Object execute(PreparedStatement ps, DatabaseMetaData dbMetaData) {
		if (resultSetHandler_ == null) {
			throw new EmptyRuntimeException("resultSetHandler");
		}
		ResultSet resultSet = PreparedStatementUtil.executeQuery(ps);
		try {
			return resultSetHandler_.handle(resultSet, dbMetaData);
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		} finally {
			ResultSetUtil.close(resultSet);
		}
	}
}