package org.seasar.framework.sel.boolexps;

import org.seasar.framework.util.LikeUtil;
import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class LikeExp implements BoolExpression {

	private Expression targetExp_;
	private Expression patternExp_;

	public LikeExp(Expression targetExp, Expression patternExp) {
		targetExp_ = targetExp;
		patternExp_ = patternExp;
	}

	public boolean evaluate(SelContext context) {
		String target = (String) targetExp_.evaluateValue(context);
		String pattern = (String) patternExp_.evaluateValue(context);
		return LikeUtil.match(pattern, target);
	}
}
