package org.seasar.framework.sel.exps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class GetPropertyExp implements Expression {

	private Expression targetExp_;
	private String name_;

	public GetPropertyExp(Expression targetExp, String name) {
		targetExp_ = targetExp;
		name_ = name;
	}

	public Object evaluateValue(SelContext context) {
		Object target = targetExp_.evaluateValue(context);
		return context.getProperty(target, name_);
	}
}
