package test.org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BeanResultSetHandler;
import org.seasar.extension.unit.S2TestCase;

public class BeanResultSetHandlerTest extends S2TestCase {

	public BeanResultSetHandlerTest(String arg0) {
		super(arg0);
	}

	public void testHandle() throws Exception {
		ResultSetHandler handler = new BeanResultSetHandler(Employee.class);
		String sql = "select * from emp where empno = 7788";
		Connection con = getConnection();
		DatabaseMetaData dbMetaData = con.getMetaData();
		PreparedStatement ps = con.prepareStatement(sql);
		Employee ret = null;
		try {
			ResultSet rs = ps.executeQuery();
			try {
				ret = (Employee) handler.handle(rs, dbMetaData);
			} finally {
				rs.close();
			}
		} finally {
			ps.close();
		}
		assertNotNull("1", ret);
		System.out.println(ret.getEmpno() + "," + ret.getEname());
	}

	public void setUp() {
		include("j2ee-config.xml");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(BeanResultSetHandlerTest.class);
	}

}
