package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.boolexps.IsNullExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class IsNullExpTest extends TestCase {

	public IsNullExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BoolExpression exp = new IsNullExp(NullExp.NULL);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(2));
		BoolExpression exp = new IsNullExp(arg1Exp);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsNullExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsNullExpTest.class.getName()});
	}
}