#!/usr/bin/env python   
# 
import optparse
import os 
import sys
import re
from xml.dom.minidom import parse

# Hardwire in appengine modules to PYTHONPATH   
# or use wrapper to do it more elegantly   
appengine_dirs = ['./google/appengine', './lib']   
sys.path.extend(appengine_dirs)   
# Add your models to path   
root_dir = os.path.abspath(os.path.dirname(__file__))   
sys.path.insert(0, root_dir)   

from google.appengine.ext import db   
from google.appengine.ext.remote_api import remote_api_stub   
import getpass   

if os.name != 'nt':
  import fcntl
  import syslog
  config = '/opt/secioss/etc/lism.conf'
else:
  import msvcrt
  config = '/secioss/etc/lism.conf'

os.environ['AUTH_DOMAIN'] = 'gmail.com'
admin = None
password = None

def usage():
  print 'gaeidsync.py [-s server] [-c config] read object suffix'
  print 'gaeidsync.py [-s server] [-c config] update ldif'
  exit(1)

def auth_func():
  global admin
  global password
  return (admin, password)

def entry2str(conf, suffix, entry):
  id = getattr(entry, conf['attrs'][conf['rdn']]['param'])
  if not id:
    return None

  entryStr = "dn: %s=%s,%s\n" % (conf['rdn'], id, suffix)
  for oc in conf['oc']:
    entryStr = entryStr + 'objectClass: ' + oc + "\n"
  for attr in conf['attrs'].keys():
    value = getattr(entry, conf['attrs'][attr]['param'])
    if value:
     entryStr = entryStr + attr + ': ' + value + "\n"
  return entryStr

def log(level, message):
  if os.name != 'nt':
    syslog.openlog('gaesync', syslog.LOG_PID, syslog.LOG_LOCAL4)
    if level == 'error':
      level = syslog.LOG_ERR
    syslog.syslog(level, message)
    syslog.closelog()
  else:
    log = open('/secioss/var/log/gaesync.log', 'a')
    log.write(message)
    log.close()

parser = optparse.OptionParser()
parser.add_option('-s', '--server', dest='server',
                  help='The hostname your app is deployed on. '
                       'Defaults to <appid>.appspot.com.')
parser.add_option('-c', '--config', dest='config',
                  help='LISM configuration file.'
                       'Default is /opt/secioss/etc/lism.conf')

(options, args) = parser.parse_args()

if len(args) < 1 or (args[0] != 'read' and args[0] != 'update'):
  usage()

op = args[0]
if op == 'read':
  if len(args) < 3:
    usage()

  search_oname = args[1]
  suffix = args[2]

if options.config:
  config = options.config

appid = None
server = None
file = None
oconf = {}

dom = parse(config)
for data in dom.getElementsByTagName('data'):
  for storage in data.getElementsByTagName('storage'):
    if storage.getAttribute('name') == 'GAE':
      appid = storage.getElementsByTagName('appid')[0].firstChild.nodeValue
      admin = storage.getElementsByTagName('admin')[0].firstChild.nodeValue
      password = storage.getElementsByTagName('passwd')[0].firstChild.nodeValue
      file = storage.getElementsByTagName('updatelog')[0].firstChild.nodeValue
      dbase = None
      for child in data.childNodes:
        if child.nodeName == 'container':
          dbase = child.getElementsByTagName('rdn')[0].firstChild.nodeValue
          break
      for object in storage.getElementsByTagName('object'):
        oname = object.getAttribute('name')
        oconf[oname] = {}
        module = __import__(oname)
        oconf[oname]['object'] = getattr(module, oname)
        oconf[oname]['oc'] = []
        basedn = None
        rdn = None
        for child in object.childNodes:
          if child.nodeName == 'container':
            basedn = child.getElementsByTagName('rdn')[0].firstChild.nodeValue + ',' + dbase
          if child.nodeName == 'rdn':
            rdn = child.firstChild.nodeValue
          if child.nodeName == 'oc':
            oconf[oname]['oc'].append(child.firstChild.nodeValue)
        oconf[oname]['rdn'] = rdn
        oconf[oname]['basedn'] = basedn
        oconf[oname]['basedn_re'] = re.compile('^' + rdn + '=([^,]+),' + basedn, re.IGNORECASE)
        oconf[oname]['attrs'] = {}
        for attr in object.getElementsByTagName('attr'):
          name = attr.getAttribute('name')
          oconf[oname]['attrs'][name] = {}
          oconf[oname]['attrs'][name]['param'] = attr.getElementsByTagName('param')[0].firstChild.nodeValue
          oconf[oname]['attrs'][name]['regex'] = re.compile('^' + name + ': ([^\n]+)')
      break

if not appid:
  print "Application ID doesn't exist"
  exit(80)

if options.server:
  server = options.server
else:
  server = '%s.appspot.com' % appid

# Use local dev server by passing in as parameter:
# servername='localhost:8080'
# Otherwise, remote_api assumes you are targeting <appid>.appspot.com
remote_api_stub.ConfigureRemoteDatastore(appid,
 '/remote_api', auth_func, servername=server)

# Do stuff like your code was running on App Engine
if op == 'update':
  dn = ''
  ldif = ''
  dn_re = re.compile('^dn: ([^\n]+)')
  mod_re = re.compile('^(add|replace|delete): ([^\n]+)')
  type_re = re.compile('^changetype: ([^\n]+)', re.IGNORECASE)

  lock = open(file + '.lock', 'w')
  if os.name != 'nt':
    fcntl.flock(lock.fileno(), fcntl.LOCK_EX)
  else:
  	msvcrt.locking(lock.fileno(), msvcrt.LK_RLCK, 0)
  os.rename(file, file + '.work')
  if os.name != 'nt':
    fcntl.flock(lock.fileno(), fcntl.LOCK_UN)
  else:
  	msvcrt.locking(lock.fileno(), msvcrt.LK_UNLCK, 0)
  lock.close()

  rc = 0
  fail = open(file + '.fail', 'a')
  f = open(file + '.work', 'r')
  for line in f:
    ldif += line
    if line == "\n":
      if rc:
        fail.write(ldif)
      rc = 0
      ldif = ''
    elif dn_re.match(line):
      dn = dn_re.match(line).group(1)
    elif type_re.match(line):
      type = type_re.match(line).group(1)
      for oname in oconf.keys():
        if not oconf[oname]['basedn_re'].match(dn):
          continue
        id = oconf[oname]['basedn_re'].match(dn).group(1)
        id_param = oconf[oname]['attrs'][oconf[oname]['rdn']]['param']
        entries = oconf[oname]['object'].gql('where ' + id_param + ' = :1', id)
        if type == 'add':
          entry = None
          if entries.count() > 0:
            log('error', 'Failed to add %s %s: already exist' % (oname, id))
            rc = 1
          else:
            entry = oconf[oname]['object']()
            setattr(entry, id_param, id)

          for line in f:
            if line == "\n":
              break
            if not entry:
              continue
            for attr in oconf[oname]['attrs'].keys():
              if attr != oconf[oname]['rdn'] and oconf[oname]['attrs'][attr]['regex'].match(line):
                value = oconf[oname]['attrs'][attr]['regex'].match(line).group(1)
                value = value.decode('utf-8')
                setattr(entry, oconf[oname]['attrs'][attr]['param'], value)
          if entry:
            entry.put()
        elif type == 'modify':
          entry = None
          if entries.count() == 0:
            log('error', 'Failed to modify %s %s: no such object' % (oname, id))
            rc = 1
          else:
            entry = entries[0]
          for line in f:
            if line == "\n":
              break
            if not entry:
              continue

            delete_all = True
            mod = mod_re.match(line)
            if mod:
              mod_type = mod.group(1)
              mod_attr = mod.group(2).lower()
            elif not oconf[oname]['attrs'].has_key(mod_attr):
              continue
            elif line == "-\n":
              if mod_type == 'delete' and delete_all:
                setattr(entry, oconf[oname]['attrs'][mod_attr]['param'], '')
              continue
            else:
              value = oconf[oname]['attrs'][mod_attr]['regex'].match(line).group(1)
              value = value.decode('utf-8')
              if mod_type == 'add' or mod_type == 'replace':
                setattr(entry, oconf[oname]['attrs'][mod_attr]['param'], value)
              elif mod_type == 'delete':
                delete_all = False
                if value == getattr(entry, oconf[oname]['attrs'][mod_attr]['param']):
                  setattr(entry, oconf[oname]['attrs'][mod_attr]['param'], '')
          if entry:
            entry.put()
        elif type == 'delete':
          if entries.count() == 0:
            log('error', 'Failed to delete %s %s: no such object' % (oname, id))
            rc = 1
          else:
            entries[0].delete()
          for line in f:
            if line == "\n":
              break
        break
  fail.close()
  f.close()
  os.unlink(file + '.work')
elif op == 'read':
  if len(args) == 4:
    id = args[3]
    id_param = oconf[search_oname]['attrs'][oconf[search_oname]['rdn']]['param']
    entries = oconf[search_oname]['object'].gql('where ' + id_param + ' = :1', id)
    if entries.count() == 0:
      exit(32)
    entry = entries[0]
    entryStr = entry2str(oconf[search_oname], suffix, entry)
    if entryStr:
      print entryStr.encode('utf-8')
  else:
    entries = oconf[search_oname]['object'].all()
    for entry in entries:
      entryStr = entry2str(oconf[search_oname], suffix, entry)
      if entryStr:
        print entryStr.encode('utf-8')
