<?php
if (file_exists('/var/www/user/templates/fatal.tpl')) {
    require_once("/var/www/lib/util.php");

    $session = SimpleSAML_Session::getInstance();
    $tenant = $session->getAttribute('tenant');
    if (!$tenant && isset($_GET['tenant'])) {
        $tenant = $_GET['tenant'];
    }
    if (is_array($tenant)) {
        $tenant = $tenant[0];
    }

    $css = null;
    $logo = null;
    if ($tenant) {
        $conf = parse_ini_file("/var/www/conf/config.ini", true);
        if (!empty($conf) && isset($conf['password'])) {
            $login = new AutoLogin($conf['password']['storage'], $conf['password']);
            $tenant_info = getTenantInfo($login, $tenant);
            if (!PEAR::isError($tenant_info) && isset($tenant_info['template'])) {
                if (isset($tenant_info['template']['css'])) {
                    $css = $tenant_info['template']['css'];
                }
                if (isset($tenant_info['template']['logo'])) {
                    $logo = $tenant_info['template']['logo'];
                }
            }
        }
    }

    $tplfile = getTemplateFile('fatal', $tenant, $lang);

    $smarty = new Smarty();
    $smarty->template_dir = '/var/www/user/templates';
    $smarty->compile_dir = '/var/www/user/templates_c';

    $errors = array(array('message' => USS_ERR_003, 'size' => 3),
                    array('message' => htmlentities($this->data['exceptionmsg']), 'size' => 1),
                    array('message' => "Error ID: ".htmlspecialchars($this->data['trackid']), 'size' => 1));
    $smarty->assign('errors', $errors);
    if ($css) {
        $smarty->assign('css', $css);
    }
    if ($logo) {
        $smarty->assign('logo', $logo);
    }

    $smarty->display($tplfile);

    exit(0);
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<title>SECIOSS</title>
<link href="/<?php echo($this->data['baseurlpath']); ?>module.php/secioss/css/secioss.css" rel="stylesheet" type="text/css" />
</head>

<body>
<a name="top" id="top"></a>
<div id="wrapper">
	<div id="header">
		<div id="title">
	 	<span class="mark"><img src="/<?php echo($this->data['baseurlpath']); ?>module.php/secioss/images/mark.gif" width="61" height="62" alt="" /></span><span class="product"><img src="/<?php echo($this->data['baseurlpath']); ?>module.php/secioss/images/ttl_app.gif" width="420" height="36" /></span><span class="logo"><img src="/<?php echo($this->data['baseurlpath']); ?>module.php/secioss/images/logo.gif" width="153" height="42" /></span>
	 	</div>
	 	<div id="tbar">
	 	<p class="inout">&nbsp;</p>
	 	</div>
	</div>
	<div id="container">
		<div id="contents">
			<div id="logout">
			<p>
			エラーが発生しました。<br>
			<?php echo htmlentities($this->data['exceptionmsg']); ?><br>
			Error ID: <?php echo htmlspecialchars($this->data['trackid']); ?><br>
			</p>
			</div>
		</div><!-- contentsここまで -->
	</div><!-- containerここまで -->
	<div id="footer">
	<p class="copyright">Copyright&copy;2016 SECIOSS, INC. All rights reserved.</p>
	</div>
</div><!-- wrapperここまで -->
</body>
</html>
