/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qmessagebox.h>
#include <qworkspace.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "downloader.h"

#include <iostream>
using namespace std;


//default constructor
Downloader::Downloader(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Download fedora"));

        optionButtonGroup = new QButtonGroup(this);
        optionButtonGroup->resize( 350, 50 );
        usRadioButton = new QRadioButton(tr("us ftp site (mirrors.kernel.org)"), optionButtonGroup);
        usRadioButton->setGeometry( 10, 10, 300, 20 );
        jpRadioButton = new QRadioButton(tr("jp ftp site (ftp.riken.jp)"), optionButtonGroup);
        jpRadioButton->setGeometry( 10, 30, 300, 20 );
	usRadioButton->setChecked(true);

        fedoraVersionButtonGroup = new QButtonGroup(this);
        fedoraVersionButtonGroup->resize( 150, 70 );
        sevenRadioButton = new QRadioButton(tr("version 7"), fedoraVersionButtonGroup);
        sevenRadioButton->setGeometry( 10, 10, 300, 20 );
        eightRadioButton = new QRadioButton(tr("version 8"), fedoraVersionButtonGroup);
        eightRadioButton->setGeometry( 10, 30, 300, 20 );
        nineRadioButton = new QRadioButton(tr("version 9"), fedoraVersionButtonGroup);
        nineRadioButton->setGeometry( 10, 50, 300, 20 );
	nineRadioButton->setChecked(true);

	downloadButton = new QPushButton(tr("Download Fedora"), this);
	downloadButton->setPaletteBackgroundColor(QColor(100,200,200));

	connect(downloadButton, SIGNAL(clicked()), this, SLOT(download_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	middleLayout = new QVBoxLayout;

	firstLayout = new QHBoxLayout;
	secondLayout = new QVBoxLayout;
	thirdLayout = new QVBoxLayout;

	//leftLayout = new QVBoxLayout;
	rightLayout = new QHBoxLayout;
	
	//leftLayout->addWidget(optionButtonGroup);
	secondLayout->addWidget(optionButtonGroup);
	thirdLayout->addWidget(fedoraVersionButtonGroup);
	firstLayout->addLayout(secondLayout);
	firstLayout->addLayout(thirdLayout);

	rightLayout->addWidget(downloadButton);
	rightLayout->addStretch();

	//middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(firstLayout);
	middleLayout->addLayout(rightLayout);


	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(middleLayout);
	//mainLayout->addLayout(firstLayout);
	mainLayout->addLayout(footLayout);
	resize(630,250);
}

void Downloader::download_button_clicked()
{
	QUrl url_for_fedora("ftp://mirrors.usc.edu");
	if(usRadioButton->isChecked()){
		QUrl url_for_fedora("ftp://mirrors.usc.edu");
		url_for_fedora.setPort(21);
		mirror = 1;
		if(sevenRadioButton->isChecked()){
			version = "seven";
		}
		if(eightRadioButton->isChecked()){
			version = "eight";
		}
		if(nineRadioButton->isChecked()){
			version = "nine";
		}
	}
	if(jpRadioButton->isChecked()){
		QUrl url_for_fedora("ftp://ftp.riken.jp");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(sevenRadioButton->isChecked()){
			version = "seven";
		}
		if(eightRadioButton->isChecked()){
			version = "eight";
		}
		if(nineRadioButton->isChecked()){
			version = "nine";
		}
	}
	downloader_process(url_for_fedora, version);
}
void Downloader::downloader_process(const QUrl &url_for_fedora, QString version)
{
	this->setEnabled(false);
	process = new QProcess(this);
	process->addArgument("/root/segatex/downloader_program");
	process->addArgument(url_for_fedora);
	process->addArgument(version);

	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();
	QMessageBox::warning(0, tr("Downloader Fedora"),
				tr("Downloading Fedora in your home directory."));
}
void Downloader::updateOutputTextEdit()
{
	QByteArray data = process->readStderr();
	//QString text = textEdit1->text() + QString(data);
	//textEdit1->setText(text);
}
void Downloader::readFromStdout()
{
	QByteArray data = process->readStdout();
	//QString text = textEdit1->text() + QString(data);
	//textEdit1->setText(text);
}
void Downloader::processExited()
{
	if(process->normalExit()){
		//textEdit1->append(tr("yum install process ended !"));
		//textEdit1->append(tr("\n"));
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloaded files are in your home directory."));
		return;
	} else {
		//textEdit1->append(tr("yum install process had an error !"));
		//textEdit1->append(tr("\n"));
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloader Fedora process had an error"));
		return;
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}

