/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <qdialog.h>
#include <qftp.h>
#include <qstringlist.h>
#include <qprogressdialog.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qdir.h> 
#include <qlabel.h> 
#include <qlineedit.h> 
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qurl.h>
#include <qprocess.h>

#include <vector>

class Downloader: public QDialog 
{
	Q_OBJECT
public:
	Downloader(QWidget *parent = 0, const char *name = 0);
public slots:
signals:
protected:
private slots:
	void download_button_clicked();
	void downloader_process(const QUrl &url_for_fedora, QString version);
	void updateOutputTextEdit();
	void readFromStdout();
	void processExited();
public:
private:
	int mirror;
	QString version;
	QProcess *process;

	QButtonGroup *optionButtonGroup;
	QButtonGroup *fedoraVersionButtonGroup;

        QRadioButton *usRadioButton;
        QRadioButton *jpRadioButton;
        QRadioButton *sevenRadioButton;
        QRadioButton *eightRadioButton;
        QRadioButton *nineRadioButton;

        QString semanageEditLineEdit_str_add_restorecon;
	QPushButton *downloadButton;
	QPushButton *closeButton;

	QVBoxLayout *mainLayout;
	QVBoxLayout *middleLayout;
	QHBoxLayout *firstLayout;
	QVBoxLayout *secondLayout;
	QVBoxLayout *thirdLayout;
	//QVBoxLayout *leftLayout;
	QHBoxLayout *rightLayout;
	//QVBoxLayout *underLayout;
	QHBoxLayout *footLayout;

        QDir dir;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;

        QStringList::Iterator it_d;
        QStringList files;

        QString radiobutton_obj_str;
        QLabel *semanageEditLabel;
        QLabel *semanageEditLabel2;
        QLineEdit *semanageEditLineEdit;
        QString semanageEditLineEdit_str;
        QString semanageEditLineEdit_str_pp;
        QString restorecon_str;

	QFtp ftp;
	std::vector<QFile *> openedFiles;
};

#endif
