/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 * shintaro.fujiwara@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <q3mainwindow.h>
#include <qwidget.h>
//Added by qt3to4:
#include <QCloseEvent>
#include <QLabel>
#include <Q3PopupMenu>

class QAction;
class QLabel;
class QWorkspace;
class QSplitter;
class Q3TextEdit;
class QPushButton;
class Editor;
class BreakTe;
class BreakIf;
class SegatexState;
class SegatexApply;
class SegatexSetenforce;
class SegatexYum;
class SegatexYumProcess;
class SegatexAudit2allow;
class SegatexCore;
class SemoduleCoreProcess;
class SemanageCoreProcess;
class SemanageCoreLoginProcess;
class SemanageCoreFcontextProcess;
class SemanageCorePortProcess;
class SemanageCoreTranslationProcess;
class SemanageCoreBooleanProcess;
class AutoRelabel;
class Policygeneration;
class Aureport;
class Ausearch;
class Useradd;
class Seeprocess;
class Restorecon;
class Downloader;

class MainWindow : public Q3MainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0, const char *name = 0);

public slots:
    void newFile();
    void openFile(const QString &fileName);
    void updateSegatexStateIndicator();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void open();

    //newly added
    //void open_break_te_raw();
    void break_te();
    void break_if();
    void howtouse();
    void enforcing();
    void yum_selinux();
    void yum_selinux_process();
    void audit2allow();
    void segatex_core();
    void semodule_core_process();
    void semanage_core_process();
    void semanage_core_login_process();
    void semanage_core_fcontext_process();
    void semanage_core_port_process();
    void semanage_core_translation_process();
    void semanage_core_boolean_process();
    void autorelabel_process();
    void policygeneration_process();
    void aureport();
    void ausearch();
    void useradd();
    void seeprocess();
    void restorecon();
    void downloader();

    void save();
    void saveAs();
    void cut();
    void copy();
    void paste();
    void del();
    void about();
    void notice();

    void updateMenus();
    void activateWindow(int param);
    void copyAvailable(bool available);
    void updateModIndicator();

private:
    void createActions();
    void createMenus();
    void createWindowsMenu();
    void createToolBars();
    void createStatusBar();
    bool modified;

    Editor *createEditor();
    Editor *activeEditor();

    QWorkspace *workspace;
    QLabel *readyLabel;
    QLabel *modLabel;
    QLabel *segatexStateLabel;
    QWidgetList windows;

    //newly added
    QSplitter *topSplitter;
    QSplitter *horizontalSplitter;
    Q3TextEdit *textEcho;
    QString selinux_policy;
    QString enabled_or_not_str;
    QString getenforce_str;

    BreakTe *breakte;
    BreakIf *breakif;
    SegatexState *segatex_state;
    SegatexApply *segatex_apply;
    SegatexSetenforce *segatex_apply_for_state;
    SegatexYum *selinux_yum;
    SegatexYumProcess *selinux_yum_process;
    SegatexAudit2allow *selinux_audit2allow;
    BreakTe *breakte_o;
    BreakIf *breakif_o;
    SegatexCore *segatex_core_o;
    SemoduleCoreProcess *semodule_core_process_o;
    SemanageCoreProcess *semanage_core_process_o;
    SemanageCoreLoginProcess *semanage_core_login_process_o;
    SemanageCoreFcontextProcess *semanage_core_fcontext_process_o;
    SemanageCorePortProcess *semanage_core_port_process_o;
    SemanageCoreTranslationProcess *semanage_core_translation_process_o;
    SemanageCoreBooleanProcess *semanage_core_boolean_process_o;
    AutoRelabel *autorelabel_process_o;
    Policygeneration *policygeneration_process_o;
    Aureport *aureport_o;
    Ausearch *ausearch_o;
    Useradd *useradd_o;
    Seeprocess *seeprocess_o;
    Restorecon *restorecon_o;
    Downloader *downloader_o;
    
    Q3PopupMenu *fileMenu;
    Q3PopupMenu *editMenu;
    Q3PopupMenu *windowsMenu;
    Q3PopupMenu *helpMenu;
    //newly added
    Q3PopupMenu *breakteMenu;
    Q3PopupMenu *breakifMenu;
    Q3PopupMenu *auditMenu;
    Q3PopupMenu *policyMenu;
    Q3PopupMenu *manageMenu;
    Q3PopupMenu *semanageMenu;
    Q3PopupMenu *relabelMenu;
    Q3PopupMenu *downloaderMenu;
    Q3PopupMenu *miscellaneousMenu;

    Q3ToolBar *fileToolBar;
    Q3ToolBar *editToolBar;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *saveAsAct;
    QAction *exitAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *deleteAct;
    QAction *closeAct;
    QAction *closeAllAct;
    QAction *tileAct;
    QAction *cascadeAct;
    QAction *nextAct;
    QAction *previousAct;
    QAction *aboutAct;
    QAction *aboutQtAct;
    //newly added
    QAction *breakteAct;
    QAction *breakifAct;
    QAction *howtouseAct;
    QAction *enforcingAct;
    QAction *check_selinuxAct;
    QAction *default_policyAct;
    QAction *selinuxYumAct;
    QAction *selinuxYumProcessAct;
    QAction *audit2allowAct;
    QAction *segatex_coreAct;
    QAction *semodule_core_processAct;
    QAction *semanage_core_processAct;
    QAction *semanage_core_login_processAct;
    QAction *semanage_core_fcontext_processAct;
    QAction *semanage_core_port_processAct;
    QAction *semanage_core_translation_processAct;
    QAction *semanage_core_boolean_processAct;
    QAction *autorelabel_processAct;
    QAction *policygeneration_processAct;
    QAction *aureportAct;
    QAction *ausearchAct;
    QAction *useraddAct;
    QAction *seeprocessAct;
    QAction *restoreconAct;
    QAction *downloaderAct;
};

#endif
