/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
#include <q3process.h>
#include <qmessagebox.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>
//#include <fstream.h>
#include <fstream>

#include "seeprocess.h"

#include <iostream>
using namespace std;

//default constructor
Seeprocess::Seeprocess(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("see process"));
		textEdit1 = new Q3TextEdit(this);
		textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
		grepLabel = new QLabel(tr("grep:"), this );
		grepEditLineEdit = new QLineEdit(this );
		grepEditLineEdit->setText(tr(""));
		grepButton = new QPushButton(tr("grep"), this);
		grepButton->setPaletteBackgroundColor(QColor(155, 155, 255));
		closeButton = new QPushButton(tr("&Close"), this);
		seeprocessButton = new QPushButton(tr("see process"), this);
		seeprocessButton->setPaletteBackgroundColor(QColor(255, 155, 155));
		grepButton->setDefault(true);
		seeprocessButton->setDefault(true);

		connect(grepButton, SIGNAL(clicked()), this, SLOT(grep_clicked()));
		connect(seeprocessButton, SIGNAL(clicked()), this, SLOT(seeprocess_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		firstLayout = new Q3VBoxLayout;
		leftLayout = new Q3HBoxLayout;
		leftLayout->addWidget(grepLabel);
		leftLayout->addWidget(grepEditLineEdit);

		rightLayout = new Q3VBoxLayout;
		rightLayout->addWidget(grepButton);
		rightLayout->addStretch(1);
		rightLayout->addWidget(seeprocessButton);
		rightLayout->addWidget(closeButton);

		firstLayout->addLayout(leftLayout);
		firstLayout->addWidget(textEdit1);

		mainLayout = new Q3HBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(firstLayout);
		mainLayout->addLayout(rightLayout);

		seeprocess_base_process();
//		readFromOutputFile();
		resize(1000,600);
}
void Seeprocess::seeprocess_clicked()
{
		seeprocess_base_process();
}
void Seeprocess::grep_clicked()
{
		grep_str = grepEditLineEdit->text();
		if(grep_str == ""){
			QMessageBox::information( this, tr("segatex alert"),
			    tr("No text given.\n"
			    "Try again !" ));
		}else{
			seeprocess_grep_process(grep_str);
		}
}
////////////////////////////////////////////
void Seeprocess::readFromStdout()
{
        QByteArray data = process->readStdout();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void Seeprocess::processExited()
{
	if(process->normalExit()){
		//textEdit1->append(tr(""));
		//textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("useradd process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void Seeprocess::seeprocess_grep_process(QString grep_str)
{
        #define PWD_BUF 8600
        const char* semanage_fcontext_list_file="/root/segatex/seeprocess_grep";
        ofstream os;
        os.open(semanage_fcontext_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
		grep_str_echo = "ps -efZ|grep " + grep_str + " |grep -v grep";
                read_fp = popen(grep_str_echo, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	readFromOutputFile_grep(grep_str);

}
void Seeprocess::seeprocess_base_process()
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("ps");
	process->addArgument("-efZ");

	outputfile_str = "seeprocess";
	path = "/root/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	readFromOutputFile();
}

//this slot should be called from above slot
void Seeprocess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/root/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("seeprocess");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
		textEdit1->setCursorPosition(0,0);
}
//this slot should be called from above slot
void Seeprocess::readFromOutputFile_grep(QString grep_str)
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("seeprocess_grep");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			//QRegExp rx_nologin("nologin");
			QRegExp rx_grep(grep_str);
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				int i;
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					i = line_analized.find( rx_grep, 0);
                                        if(i != -1){
						textEdit1->append(line_analized);
					}else{
						//do nothing
					}
				}
				textEdit1->setCursorPosition(0,0);
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
}
