/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include "segatex_core_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexCoreProcess::SegatexCoreProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Denied audit.log"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(255,187,174));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	Q3VBoxLayout *headLayout = new Q3VBoxLayout;
	headLayout->addWidget(textEdit1);

	Q3HBoxLayout *footLayout = new Q3HBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	Q3VBoxLayout *mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(700,500);

	segatex_core_pre();

}
void SegatexCoreProcess::close_button_clicked()
{
	emit segatex_core_prosess_close_button_clicked();

}
void SegatexCoreProcess::segatex_core_pre()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "/var/log/audit";
	path_to_be_written = "/root/segatex/segatex_core_pre.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("audit.log");
	colon = ":";
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	
	if ( file_w.open( QIODevice::WriteOnly | QIODevice::Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				//QTextStream stream_echo( &file );
				var1="$1";
				var2="$2";
				var3="$3";
				var4="$4";
				var5="$5";
				var6="$6";
				////////////////////////////////////////////
				QRegExp rx_denied("denied");
				////////////////////////////////////////////
				QRegExp rx_interface3("\\'\\,\\`"); 	
				QRegExp rx_interface4("\\$1"); 	
				QRegExp rx_bracket_last("\\)"); 	
				QRegExp rx_interface5("\\$2"); 	
				QRegExp rx_interface6("\\$3");
				QRegExp rx_interface7("\\$4");
				QRegExp rx_interface8("\\$5");
				QRegExp rx_interface9("\\$6");
				QRegExp rx_gen_require_close("^[ \t\n\r\f]+\\'\\)");//close before many blanks
				//rx_summary_title.setWildcard( TRUE ); 

				tab = "	";

				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					if(line_analized.find( rx_denied, 0) != -1){
						lines += line_analized;
				        }
				}
				Q3TextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	//echo
	file_w.close();
	if ( file_w.open( QIODevice::ReadOnly ) ) {
		Q3TextStream stream( &file_w );
		textEdit1->setText( stream.read() );
	}
}//end-segatex_core_pre()
