/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qmessagebox.h>

#include "segatex_state.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexState::SegatexState(){}

/* returns selinux loaded policy as QString*/
QString SegatexState::loaded_policy()
{
	QRegExp rx_policy_targeted("targeted");
	QRegExp rx_policy_strict("strict");
	QRegExp rx_policy_mls("mls");

	pol_root = selinux_default_type_path();
		
	if( pol_root.find( rx_policy_targeted, 0) != -1){
                loaded_policy_str= tr("targeted");
        }
	if( pol_root.find( rx_policy_strict, 0) != -1){
                loaded_policy_str= tr("strict");
        }
	if( pol_root.find( rx_policy_mls, 0) != -1){
                loaded_policy_str= tr("mls");
        }

        return loaded_policy_str;
}

/* returns selinux is enabled or not as QString*/
QString SegatexState::is_selinux_enabled_segatex()
{
	enabled_or_not = is_selinux_enabled();
	if(enabled_or_not == 1)
		enabled_or_not_str = tr("enabled");
	else
		enabled_or_not_str = tr("disabled");

	return enabled_or_not_str;
}

/* returns getenforce as QString*/
QString SegatexState::getenforce_segatex()
{
	getenforce = security_getenforce();
	if(getenforce == 1)
		getenforce_str = tr("enforcing");
	else if(getenforce == 0)
		getenforce_str = tr("permissive");
	else
		getenforce_str = tr("disabled");

	return getenforce_str;
}
/* returns selinux default policy type as QString*/
QString SegatexState::default_policy_type()
{
	/*I don't know why, but it returns ok.;)*/
	char *policy_type;
	policy_type = "targeted";
	char **policy_type_ptr;
	policy_type_ptr = &policy_type;
	selinux_getpolicytype(policy_type_ptr);
	default_policy_type_str = *policy_type_ptr;
	default_policy_type_str_tr = tr(default_policy_type_str);

	default_getenforcemode_str = default_getenforcemode();

	QMessageBox::information(this,tr(""),tr("SELinux default policy is " + default_policy_type_str_tr
					 + " and should be started in " + default_getenforcemode_str + "!"));

        return default_policy_type_str;
}
/* returns selinux default enforce mode as QString*/
QString SegatexState::default_getenforcemode()
{
	/*I don't know why, but it returns ok.;)*/
	int tmp_value;
	int tmp_value2;
	tmp_value = 1;//enforcing
	int *enforce;
	enforce = &tmp_value;
	tmp_value2 = selinux_getenforcemode(enforce);
	if(*enforce == 1)
		default_getenforcemode_str = tr("enforcing");
	else if(*enforce == 0)
		default_getenforcemode_str = tr("permissive");
	else if(*enforce == -1)
		default_getenforcemode_str = tr("disabled");

	return default_getenforcemode_str;
}

