/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
#include <qradiobutton.h>
#include <q3buttongroup.h>
#include <qlineedit.h>
#include <q3textedit.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semodule_core_process.h"
#include "editor.h"

#include <iostream>
using namespace std;

//default constructor
SemoduleCoreProcess::SemoduleCoreProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Semodule Process"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(255,100,200));
	textEdit2 = new Q3TextEdit(this);
	textEdit2->setPaletteBackgroundColor(QColor(200,100,255));
	moduleEditLabel = new QLabel(tr("Copy and paste module name:"), this );
	moduleEditLineEdit = new QLineEdit( this );
	moduleEditLineEdit->setText("");
	moduleEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));

	makeButton = new QPushButton(tr("Make this module"), this);
	makeButton->setPaletteBackgroundColor(QColor(20,157,20));
	connect(makeButton, SIGNAL(clicked()), this, SLOT(make_button_clicked()));
	installButton = new QPushButton(tr("Install this module"), this);
	installButton->setPaletteBackgroundColor(QColor(220,120,120));
	connect(installButton, SIGNAL(clicked()), this, SLOT(install_button_clicked()));
	updateButton = new QPushButton(tr("Update this module"), this);
	updateButton->setPaletteBackgroundColor(QColor(120,220,120));
	connect(updateButton, SIGNAL(clicked()), this, SLOT(update_button_clicked()));
	removeButton = new QPushButton(tr("Remove this module"), this);
	removeButton->setPaletteBackgroundColor(QColor(155,155,155));
	connect(removeButton, SIGNAL(clicked()), this, SLOT(remove_button_clicked()));
	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit semodule -l
	semodule_core_base_process();

	mainLayout = new Q3HBoxLayout(this);
	mainLayout->setMargin(11);
	leftLayout = new Q3VBoxLayout;
	leftLayout->addWidget(textEdit1);

	middleLayout = new Q3VBoxLayout;
	middleLayout->addWidget(textEdit2);
	middleLayout->addStretch(2);
	middleLayout->addWidget(moduleEditLabel);
	middleLayout->addWidget(moduleEditLineEdit);
	middleLayout->addStretch(5);

	rightLayout = new Q3VBoxLayout;
	middleLayout->addStretch(5);
	rightLayout->addWidget(makeButton);
	rightLayout->addWidget(installButton);
	rightLayout->addWidget(updateButton);
	rightLayout->addWidget(removeButton);
	middleLayout->addStretch(5);

	/*
	int i_local;
	i_local=1;
	QValueVector<QString>::const_iterator it = buttons.begin();
	while (it != buttons.end()){
		//cout << (*it).ascii() << endl;
		radiobutton_obj_str = (*it).ascii();
		if(i_local == 1)
			RadioButton_1 = new QRadioButton(tr(radiobutton_obj_str), this);
		
		++it;
		++i_local;
	}
	buttons.clear();
	if(RadioButton_1)
		leftLayout->addWidget(RadioButton_1);
*/

	footLayout = new Q3VBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(rightLayout);
	mainLayout->addLayout(footLayout);
	resize(800,600);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::make_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	make_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::install_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	install_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::update_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	update_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::remove_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	remove_button_clicked_process(moduleEditLineEdit_str);
}
/* this slot does just make .pp file */
void SemoduleCoreProcess::make_button_clicked_process(QString moduleEditLineEdit_str)
{
	moduleEditLineEdit_str_pp = "cd /root/segatex;make -f /usr/share/selinux/devel/Makefile " + moduleEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* make_module_file="/root/segatex/make_module_file";
        ofstream os;
        os.open(make_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semodule_core_base_process();
	//outputfile_str_common2 = make_module_file;
	outputfile_str_common2 = "make_module_file";
	readFromOutputFile2();
}
/* this slot does just semanage -i .pp file */
void SemoduleCoreProcess::install_button_clicked_process(QString moduleEditLineEdit_str)
{
	moduleEditLineEdit_str_pp = "cd /root/segatex;semodule -i " + moduleEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* install_module_file="/root/segatex/install_module_file";
        ofstream os;
        os.open(install_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();

	//set textEdit semodule -l
	semodule_core_base_process();
	//outputfile_str_common2 = install_module_file;
	outputfile_str_common2 = "install_module_file";
	readFromOutputFile2();
}
/* this slot does just semodule -u .pp file */
void SemoduleCoreProcess::update_button_clicked_process(QString moduleEditLineEdit_str)
{
	moduleEditLineEdit_str_pp = "cd /root/segatex;semodule -u " + moduleEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* update_module_file="/root/segatex/update_module_file";
        ofstream os;
        os.open(update_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semodule_core_base_process();
	//outputfile_str_common2 = update_module_file;
	outputfile_str_common2 = "update_module_file";
	readFromOutputFile2();
}
/* this slot does just semodule -r module file */
void SemoduleCoreProcess::remove_button_clicked_process(QString moduleEditLineEdit_str)
{
	moduleEditLineEdit_str_pp = "semodule -r " + moduleEditLineEdit_str;
        #define PWD_BUF 8600
        const char* remove_module_file="/root/segatex/remove_module_file";
        ofstream os;
        os.open(remove_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semodule_core_base_process();
	//outputfile_str_common2 = remove_module_file;
	outputfile_str_common2 = "remove_module_file";
	readFromOutputFile2();
}
/*
void SemoduleCoreProcess::close_button_clicked()
{
	emit semodule_core_prosess_close_button_clicked();

}
*/
/*
void SemoduleCoreProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleCoreProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("semodule core process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("semodule core process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
*/

void SemoduleCoreProcess::semodule_core_base_process()
{
        #define PWD_BUF 8600
        const char* module_list_file="/root/segatex/module_list";
        ofstream os;
        os.open(module_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("/usr/sbin/semodule -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//outputfile_str_common = module_list_file;
	outputfile_str_common = "module_list";
	readFromOutputFile();

//	for(int i=0;i<button_numbers;i++){
//		QRadioButton *radiobutton_i;
//	}

}
/*
void SemoduleCoreProcess::semodule_core_base_process()
{
cout << "process" << endl;
	outputfile_str = "semodule_l.out";
	this->setEnabled(false);
	process = new QProcess(this);
	process->addArgument("/usr/sbin/semodule");
	process->addArgument("-l");
	//process->addArgument("|");
	//process->addArgument("grep");
	//process->addArgument("[a-zA-Z0-9]");
	//process->addArgument(">");
	outputfile_str_common = outputfile_str;
	//process->addArgument(outputfile_str);
	outputfile_str_common = outputfile_str;
	//process->addArgument(outputfile_str);
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	//read from .out file
	readFromOutputFile();
}
*/

//this slot should be called from above slot
void SemoduleCoreProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				//agroup = new QButtonGroup( this );
				//button_numbers = 1;
				textEdit1->clear();
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					textEdit1->append(line_analized);
					//radiobutton_obj = line_analized + "RadioButton";
					//radiobutton_obj = line_analized;

					//radiobutton_objButton = new QRadioButton(tr(radiobutton_obj), agroup);
					//headLayout->addWidget(radiobutton_objButton);

					//radiobutton_obj = line_analized.section( ' ', 0, 0 );
					//int i = line_analized.find( QRegExp("^[ \t\n\r\f]+"), 0 );
					//int i = line_analized.find( QRegExp("[\t]"), 0 );
					//cout << "i:" << i << endl;
					//cout << "radiobutton_obj:" << radiobutton_obj << endl;
					//++button_numbers;
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
}
//this slot should be called from above slot
void SemoduleCoreProcess::readFromOutputFile2()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common2);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				textEdit2->clear();
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit2->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
}
