/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
#include <q3process.h>
#include <qmessagebox.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
//#include <fstream.h>
#include <fstream>

#include "breakif.h"

#include <iostream>
using namespace std;

//default constructor
BreakIf::BreakIf(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("break .if files"));
		textEdit1 = new Q3TextEdit(this);
		textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
		//grepLabel = new QLabel(tr("grep:"), this );
		//grepEditLineEdit = new QLineEdit(this );
		//grepEditLineEdit->setText(tr(""));
		//grepButton = new QPushButton(tr("grep"), this);
		//grepButton->setPaletteBackgroundColor(QColor(155, 155, 255));
		closeButton = new QPushButton(tr("&Close"), this);
		breakifButton = new QPushButton(tr("break .if files"), this);
		breakifButton->setPaletteBackgroundColor(QColor(255, 155, 155));
		//grepButton->setDefault(true);
		breakifButton->setDefault(true);

		//connect(grepButton, SIGNAL(clicked()), this, SLOT(grep_clicked()));
		connect(breakifButton, SIGNAL(clicked()), this, SLOT(breakif_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		firstLayout = new Q3VBoxLayout;
		leftLayout = new Q3HBoxLayout;
		//leftLayout->addWidget(grepLabel);
		//leftLayout->addWidget(grepEditLineEdit);

		rightLayout = new Q3VBoxLayout;
		//rightLayout->addWidget(grepButton);
		//rightLayout->addStretch(1);
		rightLayout->addWidget(breakifButton);
		rightLayout->addWidget(closeButton);

		firstLayout->addLayout(leftLayout);
		firstLayout->addWidget(textEdit1);

		mainLayout = new Q3HBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(firstLayout);
		mainLayout->addLayout(rightLayout);

		//breakte_base_process();
//		readFromOutputFile();
		resize(1000,600);
}
void BreakIf::breakif_clicked()
{
		breakif_base_process();
}
////////////////////////////////////////////
void BreakIf::readFromStdout()
{
        QByteArray data = process->readStdout();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void BreakIf::processExited()
{
	if(process->normalExit()){
		//textEdit1->append(tr(""));
		//textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("breakif process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void BreakIf::breakif_base_process()
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("/root/segatex/raw_if_files/breakif.sh");

	outputfile_str = "breakif";
	path = "/root/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	readFromOutputFile();
}

//this slot should be called from above slot
void BreakIf::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/root/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("breakif");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
		textEdit1->setCursorPosition(0,0);
}
