/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qapplication.h>
#include <qsplashscreen.h>
#include <qtextcodec.h>
//Added by qt3to4:
#include <QTranslator>
#include <QPixmap>
//testing for daemon
#include <stdlib.h>

#include <QSplashScreen>
#include <QtSql> 
#include <QMessageBox> 

#include "mainwindow.h"

bool createConnection()
{
	QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");
	//db.setHostName("test");
	db.setDatabaseName("/root/segatex/sqlrefpolicy.db");
	//db.setUserName("test");
	//db.setPassword("test");
	if(!db.open()){
		QMessageBox::critical(0, QObject::tr("Database Error"),
			db.lastError().text());
		return false;
	}
	return true;
}
int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	if(!createConnection())
		//return 1;
		return false;
	QTranslator appTranslator;
	appTranslator.load(QString("segatex_") + QTextCodec::locale(),
				"/root/segatex");
	app.installTranslator(&appTranslator);
	QSplashScreen *splash = new QSplashScreen;
	splash->setPixmap(QPixmap(":/images/splash.png"));

	splash->show();
	splash->showMessage(QObject::tr("Setting up the main window..."),
			Qt::AlignRight | Qt::AlignTop, Qt::white);
	//QApplication app(argc, argv);
	MainWindow mainWin;
	app.setMainWidget(&mainWin);

	if (argc > 1) {
		for (int i = 1; i < argc; ++i){
		    mainWin.openFile(argv[i]);
		}
	} else {
		mainWin.newFile();
	}

	mainWin.show();
	return app.exec();
}
