/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3buttongroup.h>
#include <qlineedit.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semanage_core_boolean_process.h"

#include <iostream>
using namespace std;

//default constructor
SemanageCoreBooleanProcess::SemanageCoreBooleanProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));

	semanageEditLabel = new QLabel(tr("Boolean:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(200,254,100));
	
	semanageEditLabel2 = new QLabel(tr("value{on|off}:"), this );
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit2->setText("");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(200,254,100));
	addButton = new QPushButton(tr("Set this boolean"), this);
	addButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(addButton, SIGNAL(clicked()), this, SLOT(add_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	semanage_core_base_boolean_process();

	mainLayout = new QVBoxLayout;
	mainLayout->setMargin(11);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QHBoxLayout;
	rightLayout = new QHBoxLayout;
	thirdLayout = new QHBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	rightLayout->addWidget(createFirstExclusiveGroup());
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);
	leftLayout->addWidget(addButton);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	middleLayout->addLayout(thirdLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	setLayout(mainLayout);
	setWindowTitle(tr("Setsebool Process"));
	resize(800,400);
}

QGroupBox *SemanageCoreBooleanProcess::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("select time"));
	temporaryRadioButton = new QRadioButton(tr("temporary"));
	permanentRadioButton = new QRadioButton(tr("permanent"));
	permanentRadioButton->setChecked(true);
	vbox = new QVBoxLayout;
	vbox->addWidget(temporaryRadioButton);
	vbox->addWidget(permanentRadioButton);
	optionButtonGroupBox->setLayout(vbox);

	return optionButtonGroupBox;
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreBooleanProcess::add_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	add_button_clicked_process(semanageEditLineEdit_str,semanageEditLineEdit2_str);
}
/* this slot does just make .pp file */
void SemanageCoreBooleanProcess::add_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str)
{
	if(temporaryRadioButton->isChecked())
		semanageEditLineEdit_str_pp = "setsebool " + semanageEditLineEdit_str + " " + semanageEditLineEdit2_str;
	if(permanentRadioButton->isChecked())
		semanageEditLineEdit_str_pp = "setsebool -P " + semanageEditLineEdit_str + " " + semanageEditLineEdit2_str;
        #define PWD_BUF 8600
        const char* make_module_file="/root/segatex/semanage/add_booleaned";
        ofstream os_add;
        os_add.open(make_module_file);
        if(os_add){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add.close();
	//set textEdit semanage -l
	semanage_core_base_boolean_process();
	//outputfile_str_common2 = make_module_file;
}
// {boolean|login|user|port|interface|fcontext|translation}
void SemanageCoreBooleanProcess::semanage_core_base_boolean_process()
{
        #define PWD_BUF 8600
        const char* semanage_boolean_list_file="/root/segatex/semanage/1_boolean";
        ofstream os_test;
        os_test.open(semanage_boolean_list_file);
        if(os_test){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("export LANG=C;/usr/sbin/semanage boolean -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_test << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os_test.close();
	//outputfile_str_common = "boolean_list";
	readFromOutputFile();
}

//this slot should be called from above slot
void SemanageCoreBooleanProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*boolean");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########boolean list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				textEdit1->setCursorPosition(0,0);
				//file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
			file.close();
		}
}
