/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
#include <qradiobutton.h>
#include <q3buttongroup.h>
#include <qlineedit.h>
#include <q3textedit.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semanage_core_process.h"
//#include "editor.h"

#include <iostream>
using namespace std;

//default constructor
SemanageCoreProcess::SemanageCoreProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Semanage Process"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(200,254,100));
	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	semanage_core_base_process();

	mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new Q3VBoxLayout;
	upperLayout->addWidget(textEdit1);

	footLayout = new Q3HBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	//mainLayout->addLayout(underLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,600);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreProcess::make_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	//make_button_clicked_process(semanageEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreProcess::install_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	//install_button_clicked_process(semanageEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreProcess::update_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	//update_button_clicked_process(semanageEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreProcess::remove_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	//remove_button_clicked_process(semanageEditLineEdit_str);
}
/* this slot does just make .pp file */
/*
void SemanageCoreProcess::make_button_clicked_process(QString semanageEditLineEdit_str)
{
	semanageEditLineEdit_str_pp = "cd /root/segatex;make -f /usr/share/selinux/devel/Makefile " + semanageEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* make_module_file="/root/segatex/make_module_file";
        ofstream os;
        os.open(make_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semanage_core_base_process();
	//outputfile_str_common2 = make_module_file;
	outputfile_str_common2 = "make_module_file";
	readFromOutputFile2();
}
*/
/* this slot does just semanage -i .pp file */
/*
void SemanageCoreProcess::install_button_clicked_process(QString semanageEditLineEdit_str)
{
	semanageEditLineEdit_str_pp = "cd /root/segatex;semodule -i " + semanageEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* install_module_file="/root/segatex/install_module_file";
        ofstream os;
        os.open(install_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();

	//set textEdit semodule -l
	semanage_core_base_process();
	//outputfile_str_common2 = install_module_file;
	outputfile_str_common2 = "install_module_file";
	readFromOutputFile2();
}
*/
/* this slot does just semodule -u .pp file */
/*
void SemanageCoreProcess::update_button_clicked_process(QString semanageEditLineEdit_str)
{
	semanageEditLineEdit_str_pp = "cd /root/segatex;semodule -u " + semanageEditLineEdit_str + ".pp";
        #define PWD_BUF 8600
        const char* update_module_file="/root/segatex/update_module_file";
        ofstream os;
        os.open(update_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semanage_core_base_process();
	//outputfile_str_common2 = update_module_file;
	outputfile_str_common2 = "update_module_file";
	readFromOutputFile2();
}
*/
/* this slot does just semodule -r module file */
/*
void SemanageCoreProcess::remove_button_clicked_process(QString moduleEditLineEdit_str)
{
	moduleEditLineEdit_str_pp = "semodule -r " + moduleEditLineEdit_str;
        #define PWD_BUF 8600
        const char* remove_module_file="/root/segatex/remove_module_file";
        ofstream os;
        os.open(remove_module_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(moduleEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
                //os.close();
        }
	os.close();
	//set textEdit semodule -l
	semanage_core_base_process();
	//outputfile_str_common2 = remove_module_file;
	outputfile_str_common2 = "remove_module_file";
	readFromOutputFile2();
}
*/
/*
void SemanageCoreProcess::close_button_clicked()
{
	emit semanage_core_prosess_close_button_clicked();

}
*/
/*
void SemanageCoreProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemanageCoreProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("semodule core process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("semodule core process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
*/

// {boolean|login|user|port|interface|fcontext|translation}

void SemanageCoreProcess::semanage_core_base_process()
{
        #define PWD_BUF 8600
        const char* semanage_login_list_file="/root/segatex/semanage/1_login_list";
        ofstream os;
        os.open(semanage_login_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage login -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os.close();
	//outputfile_str_common = "login_list";

        const char* semanage_user_list_file="/root/segatex/semanage/2_user_list";
        ofstream os2;
        os2.open(semanage_user_list_file);
        if(os2){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage user -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os2 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os2.close();

        const char* semanage_boolean_list_file="/root/segatex/semanage/3_boolean_list";
        ofstream os3;
        os3.open(semanage_boolean_list_file);
        if(os3){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage boolean -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os3 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os3.close();

        const char* semanage_port_list_file="/root/segatex/semanage/4_port_list";
        ofstream os4;
        os4.open(semanage_port_list_file);
        if(os4){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage port -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os4 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os4.close();

        const char* semanage_interface_list_file="/root/segatex/semanage/5_interface_list";
        ofstream os5;
        os5.open(semanage_interface_list_file);
        if(os5){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage interface -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os5 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os5.close();

        const char* semanage_fcontext_list_file="/root/segatex/semanage/6_fcontext_list";
        ofstream os6;
        os6.open(semanage_fcontext_list_file);
        if(os6){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage fcontext -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os6 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os6.close();

        const char* semanage_translation_list_file="/root/segatex/semanage/7_translation_list";
        ofstream os7;
        os7.open(semanage_translation_list_file);
        if(os7){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage translation -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os7 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os7.close();

	readFromOutputFile();

}

//this slot should be called from above slot
void SemanageCoreProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*list");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				if(order_x == 1)
					textEdit1->append("#########login list#########");
					textEdit1->append("");
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########boolean list#########");
					textEdit1->append("");
				if(order_x == 4)
					textEdit1->append("#########port list#########");
					textEdit1->append("");
				if(order_x == 5)
					textEdit1->append("#########interface list#########");
					textEdit1->append("");
				if(order_x == 6)
					textEdit1->append("#########fcontext list#########");
					textEdit1->append("");
				if(order_x == 7)
					textEdit1->append("#########translation list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				textEdit1->setCursorPosition(0,0);
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
