/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.annotations.Anonymous;
import org.red5.annotations.DontSerialize;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.object.BaseOutput;
import org.red5.io.object.ICustomSerializable;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.io.utils.XMLUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output
extends BaseOutput
implements org.red5.io.object.Output {
    protected static Log log = LogFactory.getLog((String)Output.class.getName());
    protected static Map<String, byte[]> stringCache = new LRUMap(10000, true);
    protected ByteBuffer buf;

    public Output(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public boolean isCustom(Object custom) {
        return false;
    }

    protected boolean checkWriteReference(Object obj) {
        if (this.hasReference(obj)) {
            this.writeReference(obj);
            return true;
        }
        return false;
    }

    @Override
    public void writeArray(Collection array, Serializer serializer) {
        if (this.checkWriteReference(array)) {
            return;
        }
        this.storeReference(array);
        this.buf.put((byte)10);
        this.buf.putInt(array.size());
        for (Object item : array) {
            serializer.serialize(this, item);
        }
    }

    @Override
    public void writeArray(Object[] array, Serializer serializer) {
        if (this.checkWriteReference(array)) {
            return;
        }
        this.storeReference(array);
        this.buf.put((byte)10);
        this.buf.putInt(array.length);
        for (Object item : array) {
            serializer.serialize(this, item);
        }
    }

    @Override
    public void writeArray(Object array, Serializer serializer) {
        if (this.checkWriteReference(array)) {
            return;
        }
        this.storeReference(array);
        this.buf.put((byte)10);
        this.buf.putInt(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            serializer.serialize(this, Array.get(array, i));
        }
    }

    @Override
    public void writeMap(Map<Object, Object> map, Serializer serializer) {
        if (this.checkWriteReference(map)) {
            return;
        }
        this.storeReference(map);
        this.buf.put((byte)8);
        int maxInt = -1;
        int i = 0;
        while (i < map.size()) {
            try {
                if (!map.containsKey(i)) {
                }
            }
            catch (ClassCastException err) {}
            break;
            maxInt = i++;
        }
        this.buf.putInt(maxInt + 1);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            if ("length".equals(key)) continue;
            this.putString(key);
            serializer.serialize(this, entry.getValue());
        }
        if (maxInt >= 0) {
            this.putString("length");
            serializer.serialize(this, maxInt + 1);
        }
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    @Override
    public void writeMap(Collection array, Serializer serializer) {
        if (this.checkWriteReference(array)) {
            return;
        }
        this.storeReference(array);
        this.buf.put((byte)8);
        this.buf.putInt(array.size() + 1);
        int idx = 0;
        for (Object item : array) {
            if (item != null) {
                this.putString(String.valueOf(idx++));
                serializer.serialize(this, item);
                continue;
            }
            ++idx;
        }
        this.putString("length");
        serializer.serialize(this, array.size() + 1);
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    @Override
    public void writeRecordSet(RecordSet recordset, Serializer serializer) {
        if (this.checkWriteReference(recordset)) {
            return;
        }
        this.storeReference(recordset);
        this.buf.put((byte)16);
        this.putString("RecordSet");
        Map<String, Object> info = recordset.serialize();
        this.putString("serverInfo");
        serializer.serialize(this, info);
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    @Override
    public boolean supportsDataType(byte type) {
        return false;
    }

    @Override
    public void writeBoolean(Boolean bol) {
        this.buf.put((byte)1);
        this.buf.put(bol != false ? (byte)1 : 0);
    }

    @Override
    public void writeCustom(Object custom) {
    }

    @Override
    public void writeDate(Date date) {
        this.buf.put((byte)11);
        this.buf.putDouble((double)date.getTime());
        this.buf.putShort((short)(TimeZone.getDefault().getRawOffset() / 60 / 1000));
    }

    @Override
    public void writeNull() {
        this.buf.put((byte)5);
    }

    @Override
    public void writeNumber(Number num) {
        this.buf.put((byte)0);
        this.buf.putDouble(num.doubleValue());
    }

    @Override
    public void writeReference(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write reference");
        }
        this.buf.put((byte)7);
        this.buf.putShort(this.getReferenceId(obj));
    }

    @Override
    public void writeObject(Object object, Serializer serializer) {
        if (this.checkWriteReference(object)) {
            return;
        }
        this.storeReference(object);
        BeanMap beanMap = new BeanMap(object);
        Set set = beanMap.entrySet();
        if (set.size() == 0 || set.size() == 1 && beanMap.containsKey((Object)"class")) {
            this.writeArbitraryObject(object, serializer);
            return;
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            this.buf.put((byte)16);
            Output.putString(this.buf, objectClass.getName());
        } else {
            this.buf.put((byte)3);
        }
        if (object instanceof ICustomSerializable) {
            ((ICustomSerializable)object).serialize(this, serializer);
            this.buf.put((byte)0);
            this.buf.put((byte)0);
            this.buf.put((byte)9);
            return;
        }
        for (Map.Entry entry : set) {
            if (entry.getKey().toString().equals("class")) continue;
            String keyName = entry.getKey().toString();
            try {
                Field field = objectClass.getDeclaredField(keyName);
                if (field.isAnnotationPresent(DontSerialize.class)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Skipping " + field.getName() + " because its marked with @DontSerialize"));
                    continue;
                }
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers)) {
                    log.warn((Object)"Using \"transient\" to declare fields not to be serialized is deprecated and will be removed in Red5 0.8, use \"@DontSerialize\" instead.");
                    continue;
                }
            }
            catch (NoSuchFieldException nfe) {
                log.debug((Object)"writeObject caught NoSuchFieldException");
            }
            Output.putString(this.buf, keyName);
            serializer.serialize(this, entry.getValue());
        }
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    @Override
    public void writeObject(Map<Object, Object> map, Serializer serializer) {
        if (this.checkWriteReference(map)) {
            return;
        }
        this.storeReference(map);
        this.buf.put((byte)3);
        boolean isBeanMap = map instanceof BeanMap;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (isBeanMap && "class".equals(entry.getKey())) continue;
            this.putString(entry.getKey().toString());
            serializer.serialize(this, entry.getValue());
        }
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    protected void writeArbitraryObject(Object object, Serializer serializer) {
        Class<?> objectClass;
        if (log.isDebugEnabled()) {
            log.debug((Object)"writeObject");
        }
        if (!(objectClass = object.getClass()).isAnnotationPresent(Anonymous.class)) {
            this.buf.put((byte)16);
            Output.putString(this.buf, objectClass.getName());
        } else {
            this.buf.put((byte)3);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Field field : objectClass.getFields()) {
            Object value;
            if (field.isAnnotationPresent(DontSerialize.class)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping " + field.getName() + " because its marked with @DontSerialize"));
                continue;
            }
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers)) {
                log.warn((Object)"Using \"transient\" to declare fields not to be serialized is deprecated and will be removed in Red5 0.8, use \"@DontSerialize\" instead.");
                continue;
            }
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException err) {
                continue;
            }
            values.put(field.getName(), value);
        }
        for (Map.Entry entry : values.entrySet()) {
            Output.putString(this.buf, (String)entry.getKey());
            serializer.serialize(this, entry.getValue());
        }
        this.buf.put((byte)0);
        this.buf.put((byte)0);
        this.buf.put((byte)9);
    }

    @Override
    public void writeString(String string) {
        byte[] encoded = Output.encodeString(string);
        int len = encoded.length;
        if (len < 65535) {
            this.buf.put((byte)2);
            this.buf.putShort((short)len);
        } else {
            this.buf.put((byte)12);
            this.buf.putInt(len);
        }
        this.buf.put(encoded);
    }

    @Override
    public void writeByteArray(ByteArray array) {
        throw new RuntimeException("ByteArray objects not supported with AMF0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] encodeString(String string) {
        byte[] encoded;
        Map<String, byte[]> map = stringCache;
        synchronized (map) {
            encoded = stringCache.get(string);
        }
        if (encoded == null) {
            java.nio.ByteBuffer buf = AMF.CHARSET.encode(string);
            encoded = new byte[buf.limit()];
            buf.get(encoded);
            Map<String, byte[]> map2 = stringCache;
            synchronized (map2) {
                stringCache.put(string, encoded);
            }
        }
        return encoded;
    }

    public static void putString(ByteBuffer buf, String string) {
        byte[] encoded = Output.encodeString(string);
        buf.putShort((short)encoded.length);
        buf.put(encoded);
    }

    @Override
    public void putString(String string) {
        Output.putString(this.buf, string);
    }

    @Override
    public void writeXML(Document xml) {
        this.buf.put((byte)15);
        this.putString(XMLUtils.docToString(xml));
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public void reset() {
        this.clearReferences();
    }
}

