/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.annotations.Anonymous;
import org.red5.annotations.DontSerialize;
import org.red5.compatibility.flex.messaging.io.ObjectProxy;
import org.red5.io.amf3.AMF3;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.DataOutput;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.io.utils.XMLUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output
extends org.red5.io.amf.Output
implements org.red5.io.object.Output {
    protected static Log log = LogFactory.getLog((String)Output.class.getName());
    private int amf3_mode = 0;
    private List<String> stringReferences = new LinkedList<String>();

    public Output(ByteBuffer buf) {
        super(buf);
    }

    protected ByteBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public boolean supportsDataType(byte type) {
        return true;
    }

    protected void writeAMF3() {
        if (this.amf3_mode == 0) {
            this.buf.put((byte)17);
        }
    }

    @Override
    public void writeBoolean(Boolean bol) {
        this.writeAMF3();
        this.buf.put(bol != false ? (byte)3 : 2);
    }

    @Override
    public void writeNull() {
        this.writeAMF3();
        this.buf.put((byte)1);
    }

    protected void putInteger(long value) {
        if (value < 0L) {
            this.buf.put((byte)(0x80L | value >> 22 & 0xFFL));
            this.buf.put((byte)(0x80L | value >> 15 & 0x7FL));
            this.buf.put((byte)(0x80L | value >> 8 & 0x7FL));
            this.buf.put((byte)(value & 0xFFL));
        } else if (value <= 127L) {
            this.buf.put((byte)value);
        } else if (value <= 16383L) {
            this.buf.put((byte)(0x80L | value >> 7 & 0x7FL));
            this.buf.put((byte)(value & 0x7FL));
        } else if (value <= 0x1FFFFFL) {
            this.buf.put((byte)(0x80L | value >> 14 & 0x7FL));
            this.buf.put((byte)(0x80L | value >> 7 & 0x7FL));
            this.buf.put((byte)(value & 0x7FL));
        } else {
            this.buf.put((byte)(0x80L | value >> 22 & 0xFFL));
            this.buf.put((byte)(0x80L | value >> 15 & 0x7FL));
            this.buf.put((byte)(0x80L | value >> 8 & 0x7FL));
            this.buf.put((byte)(value & 0xFFL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] encodeString(String string) {
        byte[] encoded;
        Map map = stringCache;
        synchronized (map) {
            encoded = (byte[])stringCache.get(string);
        }
        if (encoded == null) {
            java.nio.ByteBuffer buf = AMF3.CHARSET.encode(string);
            encoded = new byte[buf.limit()];
            buf.get(encoded);
            Map map2 = stringCache;
            synchronized (map2) {
                stringCache.put(string, encoded);
            }
        }
        return encoded;
    }

    protected void putString(String str, byte[] encoded) {
        int len = encoded.length;
        int pos = this.stringReferences.indexOf(str);
        if (pos >= 0) {
            this.putInteger(pos << 1);
            return;
        }
        this.putInteger(len << 1 | 1);
        this.buf.put(encoded);
        this.stringReferences.add(str);
    }

    @Override
    public void putString(String string) {
        if ("".equals(string)) {
            this.putInteger(1L);
            return;
        }
        byte[] encoded = Output.encodeString(string);
        this.putString(string, encoded);
    }

    @Override
    public void writeNumber(Number num) {
        this.writeAMF3();
        if (num.longValue() < -268435456L || num.longValue() > 0xFFFFFFFL) {
            this.buf.put((byte)5);
            this.buf.putDouble(num.doubleValue());
        } else if (num instanceof Long || num instanceof Integer || num instanceof Short || num instanceof Byte) {
            this.buf.put((byte)4);
            this.putInteger(num.longValue());
        } else {
            this.buf.put((byte)5);
            this.buf.putDouble(num.doubleValue());
        }
    }

    @Override
    public void writeString(String string) {
        this.writeAMF3();
        this.buf.put((byte)6);
        if ("".equals(string)) {
            this.putInteger(1L);
        } else {
            byte[] encoded = Output.encodeString(string);
            this.putString(string, encoded);
        }
    }

    @Override
    public void writeDate(Date date) {
        this.writeAMF3();
        this.buf.put((byte)8);
        if (this.hasReference(date)) {
            this.putInteger(this.getReferenceId(date) << 1);
            return;
        }
        this.storeReference(date);
        this.putInteger(1L);
        this.buf.putDouble((double)date.getTime());
    }

    @Override
    public void writeArray(Collection array, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = array.size();
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (Object item : array) {
            serializer.serialize(this, item);
        }
        --this.amf3_mode;
    }

    @Override
    public void writeArray(Object[] array, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = array.length;
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (Object item : array) {
            serializer.serialize(this, item);
        }
        --this.amf3_mode;
    }

    @Override
    public void writeArray(Object array, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = Array.getLength(array);
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (int i = 0; i < count; ++i) {
            serializer.serialize(this, Array.get(array, i));
        }
        --this.amf3_mode;
    }

    @Override
    public void writeMap(Map<Object, Object> map, Serializer serializer) {
        int i;
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(map)) {
            this.putInteger(this.getReferenceId(map) << 1);
            return;
        }
        this.storeReference(map);
        int count = 0;
        for (i = 0; i < map.size(); ++i) {
            try {
                if (!map.containsKey(i)) {
                }
            }
            catch (ClassCastException err) {}
            break;
            ++count;
        }
        ++this.amf3_mode;
        if (count == map.size()) {
            this.putInteger(count << 1 | 1);
            this.putString("");
            for (i = 0; i < count; ++i) {
                serializer.serialize(this, map.get(i));
            }
            --this.amf3_mode;
            return;
        }
        this.putInteger(count << 1 | 1);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof Number && !(key instanceof Float) && !(key instanceof Double) && ((Number)key).longValue() >= 0L && ((Number)key).longValue() < (long)count) continue;
            this.putString(key.toString());
            serializer.serialize(this, entry.getValue());
        }
        this.putString("");
        for (int i2 = 0; i2 < count; ++i2) {
            serializer.serialize(this, map.get(i2));
        }
        --this.amf3_mode;
    }

    @Override
    public void writeMap(Collection array, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        this.putInteger(1L);
        int idx = 0;
        for (Object item : array) {
            if (item != null) {
                this.putString(String.valueOf(idx));
                serializer.serialize(this, item);
            }
            ++idx;
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    protected void writeArbitraryObject(Object object, Serializer serializer) {
        Class<?> objectClass = object.getClass();
        String className = objectClass.getName();
        if (className.startsWith("org.red5.compatibility.")) {
            className = className.substring(23);
        }
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            this.putString(className);
        } else {
            this.putString("");
        }
        ++this.amf3_mode;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Field field : objectClass.getFields()) {
            Object value;
            if (field.isAnnotationPresent(DontSerialize.class)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping " + field.getName() + " because its marked with @DontSerialize"));
                continue;
            }
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers)) {
                log.warn((Object)"Using \"transient\" to declare fields not to be serialized is deprecated and will be removed in Red5 0.8, use \"@DontSerialize\" instead.");
                continue;
            }
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException err) {
                continue;
            }
            values.put(field.getName(), value);
        }
        for (Map.Entry entry : values.entrySet()) {
            this.putString((String)entry.getKey());
            serializer.serialize(this, entry.getValue());
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeObject(Object object, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)10);
        if (this.hasReference(object)) {
            this.putInteger(this.getReferenceId(object) << 1);
            return;
        }
        this.storeReference(object);
        String className = object.getClass().getName();
        if (className.startsWith("org.red5.compatibility.")) {
            className = className.substring(23);
        }
        if (object instanceof IExternalizable) {
            int type = 3;
            type = object instanceof ObjectProxy ? (type |= 0xC) : (type |= 4);
            this.putInteger(type);
            this.putString(className);
            ++this.amf3_mode;
            ((IExternalizable)object).writeExternal(new DataOutput(this, serializer));
            --this.amf3_mode;
            return;
        }
        int type = 11;
        this.putInteger(type);
        BeanMap beanMap = new BeanMap(object);
        Set set = beanMap.entrySet();
        if (set.size() == 0 || set.size() == 1 && beanMap.containsKey((Object)"class")) {
            this.writeArbitraryObject(object, serializer);
            return;
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            this.putString(className);
        } else {
            this.putString("");
        }
        ++this.amf3_mode;
        for (Map.Entry entry : set) {
            String keyName = entry.getKey().toString();
            if ("class".equals(keyName)) continue;
            try {
                Field field = objectClass.getDeclaredField(keyName);
                if (field.isAnnotationPresent(DontSerialize.class)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Skipping " + field.getName() + " because its marked with @DontSerialize"));
                    continue;
                }
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers)) {
                    log.warn((Object)"Using \"transient\" to declare fields not to be serialized is deprecated and will be removed in Red5 0.8, use \"@DontSerialize\" instead.");
                    continue;
                }
            }
            catch (NoSuchFieldException nfe) {
                log.debug((Object)"writeObject caught NoSuchFieldException");
            }
            this.putString(keyName);
            serializer.serialize(this, entry.getValue());
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeObject(Map<Object, Object> map, Serializer serializer) {
        this.writeAMF3();
        this.buf.put((byte)10);
        if (this.hasReference(map)) {
            this.putInteger(this.getReferenceId(map) << 1);
            return;
        }
        this.storeReference(map);
        int type = 11;
        this.putInteger(type);
        this.putString("");
        ++this.amf3_mode;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.putString(entry.getKey().toString());
            serializer.serialize(this, entry.getValue());
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeRecordSet(RecordSet recordset, Serializer serializer) {
        this.writeString("Not implemented.");
    }

    @Override
    public void writeXML(Document xml) {
        this.writeAMF3();
        this.buf.put((byte)11);
        if (this.hasReference(xml)) {
            this.putInteger(this.getReferenceId(xml) << 1);
            return;
        }
        byte[] encoded = Output.encodeString(XMLUtils.docToString(xml));
        this.putInteger(encoded.length << 1 | 1);
        this.buf.put(encoded);
        this.storeReference(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByteArray(ByteArray array) {
        this.writeAMF3();
        this.buf.put((byte)12);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ByteBuffer data = array.getData();
        this.putInteger(data.limit() << 1 | 1);
        byte[] tmp = new byte[data.limit()];
        int old = data.position();
        try {
            data.position(0);
            data.get(tmp);
            this.buf.put(tmp);
        }
        finally {
            data.position(old);
        }
    }
}

