/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mock;

import java.util.List;
import org.red5.io.object.DataTypes;

public class Mock {
    public static final byte TYPE_END_OF_OBJECT = 33;
    public static final byte TYPE_END_OF_ARRAY = 34;
    public static final byte TYPE_ELEMENT_SEPARATOR = 35;
    public static final byte TYPE_PROPERTY_SEPARATOR = 36;
    public static final byte TYPE_ITEM_SEPARATOR = 37;
    public static final byte TYPE_END_OF_MAP = 38;

    public static String toStringValue(byte dataType) {
        switch (dataType) {
            case 33: {
                return "End of Object";
            }
            case 34: {
                return "End of Array";
            }
            case 35: 
            case 37: {
                return ",";
            }
            case 36: {
                return "::";
            }
        }
        return "MOCK[" + (dataType - 32) + ']';
    }

    public static String listToString(List list) {
        StringBuffer sb = new StringBuffer();
        for (Object val : list) {
            if (val instanceof Byte) {
                byte type = (Byte)val;
                if (type < 32) {
                    sb.append(DataTypes.toStringValue(type));
                } else {
                    sb.append(Mock.toStringValue(type));
                }
            } else {
                if (val != null) {
                    sb.append(val.getClass().getName());
                }
                sb.append(" { ");
                sb.append(val == null ? null : val.toString());
                sb.append(" } ");
            }
            sb.append(" | ");
        }
        return sb.toString();
    }
}

