/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp3.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.amf.Output;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.io.flv.impl.Tag;
import org.red5.io.mp3.impl.MP3Header;
import org.red5.io.object.Serializer;

public class MP3Reader
implements ITagReader,
IKeyFrameDataAnalyzer {
    protected static Log log = LogFactory.getLog((String)MP3Reader.class.getName());
    private File file;
    private FileInputStream fis;
    private FileChannel channel;
    private MappedByteBuffer mappedFile;
    private ByteBuffer in;
    private ITag tag;
    private int prevSize;
    private double currentTime;
    private IKeyFrameDataAnalyzer.KeyFrameMeta frameMeta;
    private HashMap<Integer, Double> posTimeMap;
    private int dataRate;
    private boolean firstFrame;
    private ITag fileMeta;
    private long duration;
    private static IKeyFrameMetaCache frameCache;

    MP3Reader() {
    }

    public MP3Reader(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new FileInputStream(file);
        this.channel = this.fis.getChannel();
        try {
            this.mappedFile = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        }
        catch (IOException e) {
            log.error((Object)"MP3Reader :: MP3Reader ::>\n", (Throwable)e);
        }
        this.mappedFile.order(ByteOrder.BIG_ENDIAN);
        this.in = ByteBuffer.wrap((java.nio.ByteBuffer)this.mappedFile);
        this.analyzeKeyFrames();
        this.firstFrame = true;
        this.processID3v2Header();
        this.fileMeta = this.createFileMeta();
        if (this.in.remaining() > 4) {
            this.searchNextFrame();
            int pos = this.in.position();
            MP3Header header = this.readHeader();
            this.in.position(pos);
            if (header != null) {
                this.checkValidHeader(header);
            } else {
                throw new RuntimeException("No initial header found.");
            }
        }
    }

    public boolean hasVideo() {
        return false;
    }

    public void setFrameCache(IKeyFrameMetaCache frameCache) {
        MP3Reader.frameCache = frameCache;
    }

    private void checkValidHeader(MP3Header header) {
        switch (header.getSampleRate()) {
            case 5513: 
            case 11025: 
            case 22050: 
            case 44100: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported sample rate: " + header.getSampleRate());
            }
        }
    }

    private ITag createFileMeta() {
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("duration", (double)this.frameMeta.timestamps[this.frameMeta.timestamps.length - 1] / 1000.0);
        props.put("audiocodecid", (byte)2);
        if (this.dataRate > 0) {
            props.put("audiodatarate", this.dataRate);
        }
        props.put("canSeekToEnd", true);
        out.writeMap(props, new Serializer());
        buf.flip();
        Tag result = new Tag(18, 0, buf.limit(), null, this.prevSize);
        result.setBody(buf);
        return result;
    }

    public void searchNextFrame() {
        while (this.in.remaining() > 1) {
            int ch = this.in.get() & 0xFF;
            if (ch != 255 || (this.in.get() & 0xE0) != 224) continue;
            this.in.position(this.in.position() - 2);
            return;
        }
    }

    public IStreamableFile getFile() {
        return null;
    }

    public int getOffset() {
        return 0;
    }

    public long getBytesRead() {
        return this.in.position();
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean hasMoreTags() {
        MP3Header header = null;
        while (header == null && this.in.remaining() > 4) {
            try {
                header = new MP3Header(this.in.getInt());
            }
            catch (IOException e) {
                log.error((Object)"MP3Reader :: hasMoreTags ::>\n", (Throwable)e);
                break;
            }
            catch (Exception e) {
                this.searchNextFrame();
            }
        }
        if (header == null) {
            return false;
        }
        if (header.frameSize() == 0) {
            return false;
        }
        if (this.in.position() + header.frameSize() - 4 > this.in.limit()) {
            this.in.position(this.in.limit());
            return false;
        }
        this.in.position(this.in.position() - 4);
        return true;
    }

    private MP3Header readHeader() {
        MP3Header header = null;
        while (header == null && this.in.remaining() > 4) {
            try {
                header = new MP3Header(this.in.getInt());
            }
            catch (IOException e) {
                log.error((Object)"MP3Reader :: readTag ::>\n", (Throwable)e);
                break;
            }
            catch (Exception e) {
                this.searchNextFrame();
            }
        }
        return header;
    }

    public synchronized ITag readTag() {
        if (this.firstFrame) {
            this.firstFrame = false;
            return this.fileMeta;
        }
        MP3Header header = this.readHeader();
        if (header == null) {
            return null;
        }
        int frameSize = header.frameSize();
        if (frameSize == 0) {
            return null;
        }
        if (this.in.position() + frameSize - 4 > this.in.limit()) {
            this.in.position(this.in.limit());
            return null;
        }
        this.tag = new Tag(8, (int)this.currentTime, frameSize + 1, null, this.prevSize);
        this.prevSize = frameSize + 1;
        this.currentTime += header.frameDuration();
        ByteBuffer body = ByteBuffer.allocate((int)this.tag.getBodySize());
        byte tagType = 34;
        switch (header.getSampleRate()) {
            case 44100: {
                tagType = (byte)(tagType | 0xC);
                break;
            }
            case 22050: {
                tagType = (byte)(tagType | 8);
                break;
            }
            case 11025: {
                tagType = (byte)(tagType | 4);
                break;
            }
            default: {
                tagType = (byte)(tagType | 0);
            }
        }
        tagType = (byte)(tagType | (header.isStereo() ? 1 : 0));
        body.put(tagType);
        int limit = this.in.limit();
        body.putInt(header.getData());
        this.in.limit(this.in.position() + frameSize - 4);
        body.put(this.in);
        body.flip();
        this.in.limit(limit);
        this.tag.setBody(body);
        return this.tag;
    }

    public void close() {
        if (this.posTimeMap != null) {
            this.posTimeMap.clear();
        }
        this.mappedFile.clear();
        if (this.in != null) {
            this.in.release();
            this.in = null;
        }
        try {
            this.fis.close();
            this.channel.close();
        }
        catch (IOException e) {
            log.error((Object)"MP3Reader :: close ::>\n", (Throwable)e);
        }
    }

    public void decodeHeader() {
    }

    public void position(long pos) {
        if (pos == Long.MAX_VALUE) {
            this.in.position(this.in.limit());
            this.currentTime = this.duration;
            return;
        }
        this.in.position((int)pos);
        this.searchNextFrame();
        this.analyzeKeyFrames();
        Double time = this.posTimeMap.get(this.in.position());
        this.currentTime = time != null ? time : 0.0;
    }

    public synchronized IKeyFrameDataAnalyzer.KeyFrameMeta analyzeKeyFrames() {
        int pos;
        MP3Header header;
        if (this.frameMeta != null) {
            return this.frameMeta;
        }
        if (frameCache != null) {
            this.frameMeta = frameCache.loadKeyFrameMeta(this.file);
            if (this.frameMeta != null && this.frameMeta.duration > 0L) {
                this.duration = this.frameMeta.duration;
                this.frameMeta.audioOnly = true;
                this.posTimeMap = new HashMap();
                for (int i = 0; i < this.frameMeta.positions.length; ++i) {
                    this.posTimeMap.put((int)this.frameMeta.positions[i], Double.valueOf(this.frameMeta.timestamps[i]));
                }
                return this.frameMeta;
            }
        }
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        ArrayList<Double> timestampList = new ArrayList<Double>();
        this.dataRate = 0;
        long rate = 0L;
        int count = 0;
        int origPos = this.in.position();
        double time = 0.0;
        this.in.position(0);
        this.processID3v2Header();
        this.searchNextFrame();
        while (this.hasMoreTags() && (header = this.readHeader()) != null && header.frameSize() != 0 && (pos = this.in.position() - 4) + header.frameSize() <= this.in.limit()) {
            positionList.add(pos);
            timestampList.add(time);
            rate += (long)(header.getBitRate() / 1000);
            time += header.frameDuration();
            this.in.position(pos + header.frameSize());
            ++count;
        }
        this.in.position(origPos);
        this.duration = (long)time;
        this.dataRate = (int)(rate / (long)count);
        this.posTimeMap = new HashMap();
        this.frameMeta = new IKeyFrameDataAnalyzer.KeyFrameMeta();
        this.frameMeta.duration = this.duration;
        this.frameMeta.positions = new long[positionList.size()];
        this.frameMeta.timestamps = new int[timestampList.size()];
        this.frameMeta.audioOnly = true;
        for (int i = 0; i < this.frameMeta.positions.length; ++i) {
            this.frameMeta.positions[i] = ((Integer)positionList.get(i)).intValue();
            this.frameMeta.timestamps[i] = ((Double)timestampList.get(i)).intValue();
            this.posTimeMap.put((Integer)positionList.get(i), (Double)timestampList.get(i));
        }
        if (frameCache != null) {
            frameCache.saveKeyFrameMeta(this.file, this.frameMeta);
        }
        return this.frameMeta;
    }

    private void processID3v2Header() {
        if (this.in.remaining() <= 10) {
            return;
        }
        int start = this.in.position();
        byte a = this.in.get();
        byte b = this.in.get();
        byte c = this.in.get();
        if (a != 73 || b != 68 || c != 51) {
            this.in.position(start);
            return;
        }
        this.in.skip(3);
        int size = (this.in.get() & 0x7F) << 21 | (this.in.get() & 0x7F) << 14 | (this.in.get() & 0x7F) << 7 | this.in.get() & 0x7F;
        this.in.skip(size);
    }
}

