/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.io.object.DataTypes;
import org.red5.io.object.Input;

public class Deserializer {
    protected static Log log = LogFactory.getLog((String)Deserializer.class.getName());

    public Object deserialize(Input in) {
        Object result;
        byte type = in.readDataType();
        while (type == 0) {
            type = in.readDataType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Datatype: " + DataTypes.toStringValue(type)));
        }
        switch (type) {
            case 1: {
                result = in.readNull();
                break;
            }
            case 2: {
                result = in.readBoolean();
                break;
            }
            case 3: {
                result = in.readNumber();
                break;
            }
            case 4: {
                result = in.readString();
                break;
            }
            case 5: {
                result = in.readDate();
                break;
            }
            case 6: {
                result = in.readArray(this);
                break;
            }
            case 7: {
                result = in.readMap(this);
                break;
            }
            case 8: {
                result = in.readXML();
                break;
            }
            case 9: {
                result = in.readObject(this);
                break;
            }
            case 16: {
                result = in.readByteArray();
                break;
            }
            case 17: {
                result = in.readReference();
                break;
            }
            default: {
                result = in.readCustom();
            }
        }
        if (type >= 9) {
            result = this.postProcessExtension(result);
        }
        return result;
    }

    protected Object postProcessExtension(Object result) {
        return result;
    }
}

