/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static Logger logger = Logger.getLogger(DOM2Writer.class);

    public static void serializeAsXML(Node node, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        DOM2Writer.print(node, out);
        out.flush();
    }

    private static void print(Node node, PrintWriter out) {
        if (node == null) {
            return;
        }
        boolean hasChildren = false;
        short type = node.getNodeType();
        NodeList children = null;
        switch (type) {
            case 9: {
                children = node.getChildNodes();
                if (children == null) break;
                int numChildren = children.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    DOM2Writer.print(children.item(i), out);
                }
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                if (node.hasAttributes()) {
                    NamedNodeMap attrs = node.getAttributes();
                    int len = attrs != null ? attrs.getLength() : 0;
                    for (int a = 0; a < len; ++a) {
                        Attr attr = (Attr)attrs.item(a);
                        out.print(' ');
                        out.print(attr.getNodeName());
                        out.print("=\"");
                        out.print(attr.getValue());
                        out.print('\"');
                    }
                }
                if ((children = node.getChildNodes()) != null) {
                    int numChildren = children.getLength();
                    boolean bl = hasChildren = numChildren > 0;
                    if (hasChildren) {
                        out.print('>');
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        DOM2Writer.print(children.item(i), out);
                    }
                } else {
                    hasChildren = false;
                }
                if (hasChildren) break;
                out.print("/>");
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(node.getNodeValue());
                break;
            }
            default: {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Unknown type: " + type));
            }
        }
        if (type == 1 && hasChildren) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
            hasChildren = false;
        }
    }
}

