/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.utils.HexDump;

public class IOUtils {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    public static void writeReverseInt(ByteBuffer out, int value) {
        byte[] bytes = new byte[4];
        ByteBuffer rev = ByteBuffer.allocate((int)4);
        rev.putInt(value);
        rev.flip();
        bytes[3] = rev.get();
        bytes[2] = rev.get();
        bytes[1] = rev.get();
        bytes[0] = rev.get();
        out.put(bytes);
        rev.release();
        rev = null;
    }

    public static void writeMediumInt(ByteBuffer out, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.put(bytes);
    }

    public static int readUnsignedMediumInt(ByteBuffer in) {
        int val = 0;
        val += (in.get() & 0xFF) * 256 * 256;
        val += (in.get() & 0xFF) * 256;
        return val += in.get() & 0xFF;
    }

    public static int readMediumInt(ByteBuffer in) {
        ByteBuffer buf = ByteBuffer.allocate((int)4);
        buf.put((byte)0);
        buf.put(in.get());
        buf.put(in.get());
        buf.put(in.get());
        buf.flip();
        return buf.getInt();
    }

    public static int readMediumInt2(ByteBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += bytes[0] * 256 * 256;
        val += bytes[1] * 256;
        if ((val += bytes[2]) < 0) {
            val += 256;
        }
        return val;
    }

    public static int readReverseInt(ByteBuffer in) {
        byte[] bytes = new byte[4];
        in.get(bytes);
        int val = 0;
        val += bytes[3] * 256 * 256 * 256;
        val += bytes[2] * 256 * 256;
        val += bytes[1] * 256;
        return val += bytes[0];
    }

    public static void debug(Log log, String msg, ByteBuffer buf) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
            log.debug((Object)("Size: " + buf.remaining()));
            log.debug((Object)("Data:\n\n" + HexDump.formatHexDump(buf.getHexDump())));
            String string = IOUtils.toString(buf);
            log.debug((Object)("\n" + string + "\n"));
        }
    }

    public static String toString(ByteBuffer buf) {
        int pos = buf.position();
        int limit = buf.limit();
        java.nio.ByteBuffer strBuf = buf.buf();
        String string = CHARSET.decode(strBuf).toString();
        buf.position(pos);
        buf.limit(limit);
        return string;
    }
}

