/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.red5.server.PersistableAttributeStore;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicScope
extends PersistableAttributeStore
implements IBasicScope {
    protected IScope parent;
    protected Set<IEventListener> listeners;
    protected String persistenceClass;
    protected boolean keepOnDisconnect = false;

    public BasicScope(IScope parent, String type, String name, boolean persistent) {
        super(type, name, null, persistent);
        this.parent = parent;
        this.listeners = new HashSet<IEventListener>();
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public IScope getParent() {
        return this.parent;
    }

    @Override
    public int getDepth() {
        return this.parent.getDepth() + 1;
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + '/' + this.parent.getName();
    }

    @Override
    public void addEventListener(IEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(IEventListener listener) {
        this.listeners.remove(listener);
        if (!this.keepOnDisconnect && ScopeUtils.isRoom(this) && this.listeners.isEmpty()) {
            this.parent.removeChildScope(this);
        }
    }

    @Override
    public Iterator<IEventListener> getEventListeners() {
        return this.listeners.iterator();
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return false;
    }

    @Override
    public void notifyEvent(IEvent event) {
    }

    @Override
    public void dispatchEvent(IEvent event) {
        for (IEventListener listener : this.listeners) {
            if (event.getSource() != null && event.getSource() == listener) continue;
            listener.notifyEvent(event);
        }
    }

    @Override
    public Iterator<IBasicScope> iterator() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EmptyBasicScopeIterator
    implements Iterator<IBasicScope> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IBasicScope next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

