/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.AttributeStore;
import org.red5.server.ClientMBean;
import org.red5.server.ClientRegistry;
import org.red5.server.api.IBWControllable;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends AttributeStore
implements IClient,
ClientMBean {
    protected static Log log = LogFactory.getLog((String)Client.class.getName());
    protected static final String PERMISSIONS = "_transient_red5_permissions";
    protected Map<IConnection, IScope> connToScope = new ConcurrentHashMap<IConnection, IScope>();
    protected long creationTime;
    protected String id;
    private ObjectName oName;
    protected ClientRegistry registry;

    public Client() {
    }

    public Client(String id, ClientRegistry registry) {
        this.id = id;
        this.registry = registry;
        this.creationTime = System.currentTimeMillis();
        this.oName = JMXFactory.createObjectName("type", "Client", "id", id);
        JMXAgent.registerMBean((Object)this, this.getClass().getName(), ClientMBean.class, this.oName);
    }

    @Override
    public void disconnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disconnect, closing " + this.getConnections().size() + " connections"));
        }
        for (IConnection con : this.getConnections()) {
            con.close();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Client)) {
            return false;
        }
        return ((Client)obj).getId().equals(this.id);
    }

    @Override
    public IBandwidthConfigure getBandwidthConfigure() {
        return null;
    }

    @Override
    public Set<IConnection> getConnections() {
        return this.connToScope.keySet();
    }

    @Override
    public Set<IConnection> getConnections(IScope scope) {
        if (scope == null) {
            return this.getConnections();
        }
        HashSet<IConnection> result = new HashSet<IConnection>();
        for (Map.Entry<IConnection, IScope> entry : this.connToScope.entrySet()) {
            if (!scope.equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IBWControllable getParentBWControllable() {
        return null;
    }

    @Override
    public Collection<IScope> getScopes() {
        return this.connToScope.values();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public List<String> iterateScopeNameList() {
        log.debug((Object)"iterateScopeNameList called");
        ArrayList<String> scopeNames = new ArrayList<String>();
        log.debug((Object)("Scopes: " + this.connToScope.values().size()));
        for (IScope scope : this.connToScope.values()) {
            log.debug((Object)("Client scope: " + scope));
            for (Map.Entry<String, Object> entry : scope.getAttributes().entrySet()) {
                log.debug((Object)("Client scope attr: " + entry.getKey() + " = " + entry.getValue()));
            }
        }
        return scopeNames;
    }

    protected void register(IConnection conn) {
        log.debug((Object)"Registering connection for this client");
        this.connToScope.put(conn, conn.getScope());
    }

    @Override
    public void setBandwidthConfigure(IBandwidthConfigure config) {
    }

    public String toString() {
        return "Client: " + this.id;
    }

    protected void unregister(IConnection conn) {
        this.connToScope.remove(conn);
        if (this.connToScope.isEmpty()) {
            if (this.registry != null) {
                this.registry.removeClient(this);
            }
            JMXAgent.unregisterMBean(this.oName);
        }
    }

    @Override
    public Collection<String> getPermissions(IConnection conn) {
        Collection result = (Collection)conn.getAttribute(PERMISSIONS);
        if (result == null) {
            result = Collections.EMPTY_SET;
        }
        return result;
    }

    @Override
    public boolean hasPermission(IConnection conn, String permissionName) {
        Collection<String> permissions = this.getPermissions(conn);
        return permissions.contains(permissionName);
    }

    @Override
    public void setPermissions(IConnection conn, Collection<String> permissions) {
        if (permissions == null) {
            conn.removeAttribute(PERMISSIONS);
        } else {
            conn.setAttribute(PERMISSIONS, permissions);
        }
    }
}

