/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.Client;
import org.red5.server.ClientList;
import org.red5.server.ClientRegistryMBean;
import org.red5.server.api.IClient;
import org.red5.server.api.IClientRegistry;
import org.red5.server.exception.ClientNotFoundException;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.jmx.JMXAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRegistry
implements IClientRegistry,
ClientRegistryMBean {
    private Map<String, IClient> clients = new ConcurrentHashMap<String, IClient>();
    private AtomicInteger nextId = new AtomicInteger();

    public ClientRegistry() {
        JMXAgent.registerMBean(this, this.getClass().getName(), ClientRegistryMBean.class);
    }

    protected void addClient(IClient client) {
        this.clients.put(client.getId(), client);
    }

    @Override
    public Client getClient(String id) throws ClientNotFoundException {
        if (!this.hasClient(id)) {
            throw new ClientNotFoundException(id);
        }
        return (Client)this.clients.get(id);
    }

    public ClientList<Client> getClientList() {
        ClientList<Client> list = new ClientList<Client>();
        for (IClient c : this.clients.values()) {
            list.add((Client)c);
        }
        return list;
    }

    protected boolean hasClients() {
        return !this.clients.isEmpty();
    }

    protected Collection<IClient> getClients() {
        if (!this.hasClients()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this.clients.values());
    }

    @Override
    public boolean hasClient(String id) {
        if (id == null) {
            return false;
        }
        return this.clients.containsKey(id);
    }

    @Override
    public IClient lookupClient(String id) throws ClientNotFoundException {
        if (!this.hasClient(id)) {
            throw new ClientNotFoundException(id);
        }
        return this.clients.get(id);
    }

    @Override
    public IClient newClient(Object[] params) throws ClientNotFoundException, ClientRejectedException {
        Client client = new Client(this.nextId(), this);
        this.addClient(client);
        return client;
    }

    @Override
    public String nextId() {
        return "" + this.nextId.getAndIncrement();
    }

    @Override
    public String previousId() {
        return "" + this.nextId.get();
    }

    protected void removeClient(IClient client) {
        this.clients.remove(client.getId());
    }
}

