/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.red5.server.ContextMBean;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IContext;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IMappingStrategy;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.IScopeResolver;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ScopeHandlerNotFoundException;
import org.red5.server.service.ServiceNotFoundException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.Resource;

public class Context
implements IContext,
ApplicationContextAware,
ContextMBean {
    public static Logger logger = Logger.getLogger((String)Context.class.getName());
    private ApplicationContext applicationContext;
    private BeanFactory coreContext;
    private String contextPath = "";
    private IScopeResolver scopeResolver;
    private IClientRegistry clientRegistry;
    private IServiceInvoker serviceInvoker;
    private IMappingStrategy mappingStrategy;
    private IPersistenceStore persistanceStore;

    public Context() {
    }

    public Context(ApplicationContext context, String contextPath) {
        this.setApplicationContext(context);
        this.contextPath = contextPath;
    }

    public IGlobalScope getGlobalScope() {
        return this.scopeResolver.getGlobalScope();
    }

    public IScopeResolver getScopeResolver() {
        return this.scopeResolver;
    }

    public IScope resolveScope(String path) {
        return this.scopeResolver.resolveScope(path);
    }

    public void setClientRegistry(IClientRegistry clientRegistry) {
        this.clientRegistry = clientRegistry;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public void setScopeResolver(IScopeResolver scopeResolver) {
        this.scopeResolver = scopeResolver;
    }

    public void setServiceInvoker(IServiceInvoker serviceInvoker) {
        this.serviceInvoker = serviceInvoker;
    }

    public IPersistenceStore getPersistanceStore() {
        return this.persistanceStore;
    }

    public void setPersistanceStore(IPersistenceStore persistanceStore) {
        this.persistanceStore = persistanceStore;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
        String deploymentType = System.getProperty("red5.deployment.type");
        logger.debug((Object)("Deployment type: " + deploymentType));
        if (deploymentType == null) {
            this.coreContext = ContextSingletonBeanFactoryLocator.getInstance((String)"red5.xml").useBeanFactory("red5.core").getFactory();
        } else {
            logger.info((Object)"Setting parent bean factory as core");
            this.coreContext = this.applicationContext.getParentBeanFactory();
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + '/';
        }
        this.contextPath = contextPath;
    }

    public IClientRegistry getClientRegistry() {
        return this.clientRegistry;
    }

    public IScope getScope() {
        return null;
    }

    public IServiceInvoker getServiceInvoker() {
        return this.serviceInvoker;
    }

    public Object lookupService(String serviceName) {
        serviceName = this.getMappingStrategy().mapServiceName(serviceName);
        try {
            Object bean = this.applicationContext.getBean(serviceName);
            if (bean != null) {
                return bean;
            }
            throw new ServiceNotFoundException(serviceName);
        }
        catch (NoSuchBeanDefinitionException err) {
            throw new ServiceNotFoundException(serviceName);
        }
    }

    public IScopeHandler lookupScopeHandler(String contextPath) {
        String scopeHandlerName = this.getMappingStrategy().mapScopeHandlerName(contextPath);
        Object bean = this.applicationContext.getBean(scopeHandlerName);
        if (bean != null && bean instanceof IScopeHandler) {
            return (IScopeHandler)bean;
        }
        throw new ScopeHandlerNotFoundException(scopeHandlerName);
    }

    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public Resource[] getResources(String pattern) throws IOException {
        return this.applicationContext.getResources(this.contextPath + pattern);
    }

    public Resource getResource(String path) {
        return this.applicationContext.getResource(this.contextPath + path);
    }

    public IScope resolveScope(String host, String path) {
        return this.scopeResolver.resolveScope(path);
    }

    public Object getBean(String beanId) {
        Object bean = null;
        try {
            bean = this.applicationContext.getBean(beanId);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.info((Object)("Bean lookup failed for " + beanId + " in the application context"));
            logger.debug((Object)e);
        }
        if (bean == null) {
            bean = this.getCoreService(beanId);
        }
        return bean;
    }

    public Object getCoreService(String beanId) {
        return this.coreContext.getBean(beanId);
    }

    public void setCoreBeanFactory(BeanFactory core) {
        this.coreContext = core;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

