/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.CoreHandlerMBean;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IClient;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.service.IServiceCall;

public class CoreHandler
implements IScopeHandler,
CoreHandlerMBean {
    protected static Log log = LogFactory.getLog((String)CoreHandler.class.getName());

    public boolean addChildScope(IBasicScope scope) {
        return true;
    }

    public boolean connect(IConnection conn, IScope scope) {
        return this.connect(conn, scope, null);
    }

    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        log.debug((Object)"Connect to core handler ?");
        String id = conn.getSessionId();
        IScope connectionScope = Red5.getConnectionLocal().getScope();
        IClientRegistry clientRegistry = connectionScope.getContext().getClientRegistry();
        IClient client = clientRegistry.hasClient(id) ? clientRegistry.lookupClient(id) : clientRegistry.newClient(params);
        conn.initialize(client);
        return true;
    }

    public void disconnect(IConnection conn, IScope scope) {
    }

    public boolean join(IClient client, IScope scope) {
        return true;
    }

    public void leave(IClient client, IScope scope) {
    }

    public void removeChildScope(IBasicScope scope) {
    }

    public boolean serviceCall(IConnection conn, IServiceCall call) {
        IContext context = conn.getScope().getContext();
        if (call.getServiceName() != null) {
            context.getServiceInvoker().invoke(call, context);
        } else {
            context.getServiceInvoker().invoke(call, conn.getScope().getHandler());
        }
        return true;
    }

    public boolean start(IScope scope) {
        return true;
    }

    public void stop(IScope scope) {
    }

    public boolean handleEvent(IEvent event) {
        return false;
    }
}

