/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.red5.server.BasicScope;
import org.red5.server.ScopeMBean;
import org.red5.server.Server;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeAware;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.IServer;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.persistence.PersistenceUtils;
import org.red5.server.api.statistics.IScopeStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope
extends BasicScope
implements IScope,
IScopeStatistics,
ScopeMBean {
    private static final Logger logger = Logger.getLogger(Scope.class);
    protected static Log log = LogFactory.getLog((String)Scope.class.getName());
    private static final String TYPE = "scope";
    private static final int UNSET = -1;
    private boolean autoStart = true;
    private final Map<String, IBasicScope> children = new ConcurrentHashMap<String, IBasicScope>();
    private final Map<IClient, Set<IConnection>> clients = new ConcurrentHashMap<IClient, Set<IConnection>>();
    private final StatisticsCounter clientStats = new StatisticsCounter();
    private final StatisticsCounter connectionStats = new StatisticsCounter();
    private IContext context;
    private long creationTime;
    private int depth = -1;
    private boolean enabled = true;
    private IScopeHandler handler;
    private boolean running;
    private volatile Map<String, Object> serviceHandlers;
    private final StatisticsCounter subscopeStats = new StatisticsCounter();
    private ObjectName oName;

    public Scope() {
        this(null);
        this.creationTime = System.currentTimeMillis();
    }

    public Scope(String name) {
        super((IScope)null, TYPE, name, false);
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public boolean addChildScope(IBasicScope scope) {
        IServer server;
        if (scope.getStore() == null) {
            try {
                if (scope instanceof Scope) {
                    ((Scope)scope).setPersistenceClass(this.persistenceClass);
                }
            }
            catch (Exception error) {
                log.error((Object)"Could not set persistence class.", (Throwable)error);
            }
        }
        if (this.hasHandler() && !this.getHandler().addChildScope(scope)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to add child scope: " + scope + " to " + this));
            }
            return false;
        }
        if (scope instanceof IScope && this.hasHandler() && !this.getHandler().start((IScope)scope)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to start child scope: " + scope + " in " + this));
            }
            return false;
        }
        if (scope instanceof IScope && (server = this.getServer()) instanceof Server) {
            ((Server)server).notifyScopeCreated((IScope)scope);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add child scope: " + scope + " to " + this));
        }
        this.children.put(scope.getType() + ":" + scope.getName(), scope);
        return true;
    }

    @Override
    public boolean connect(IConnection conn) {
        return this.connect(conn, null);
    }

    @Override
    public synchronized boolean connect(IConnection conn, Object[] params) {
        IServer server;
        Set<IConnection> conns;
        if (this.hasParent() && !this.parent.connect(conn, params)) {
            return false;
        }
        if (this.hasHandler() && !this.getHandler().connect(conn, this, params)) {
            return false;
        }
        IClient client = conn.getClient();
        if (!this.clients.containsKey(client)) {
            if (this.hasHandler() && !this.getHandler().join(client, this)) {
                return false;
            }
            conns = new HashSet<IConnection>();
            conns.add(conn);
            this.clients.put(conn.getClient(), conns);
            log.debug((Object)"adding client");
            this.clientStats.increment();
        } else {
            conns = this.clients.get(client);
            conns.add(conn);
        }
        this.addEventListener(conn);
        this.connectionStats.increment();
        if (this.equals(conn.getScope()) && (server = this.getServer()) instanceof Server) {
            ((Server)server).notifyConnected(conn);
        }
        return true;
    }

    @Override
    public boolean createChildScope(String name) {
        Scope scope = new Scope(name);
        scope.setParent(this);
        this.subscopeStats.increment();
        return this.addChildScope(scope);
    }

    @Override
    public void destory() {
        if (this.hasParent()) {
            this.parent.removeChildScope(this);
        }
        if (this.hasHandler()) {
            this.handler.stop(this);
        }
    }

    @Override
    public synchronized void disconnect(IConnection conn) {
        IClient client = conn.getClient();
        if (client != null && this.clients.containsKey(client)) {
            IServer server;
            Set<IConnection> conns = this.clients.get(client);
            conns.remove(conn);
            IScopeHandler handler = null;
            if (this.hasHandler()) {
                handler = this.getHandler();
                try {
                    handler.disconnect(conn, this);
                }
                catch (Exception e) {
                    log.error((Object)("Error while executing \"disconnect\" for connection " + conn + " on handler " + handler), (Throwable)e);
                }
            }
            if (conns.isEmpty()) {
                this.clients.remove(client);
                this.clientStats.decrement();
                if (handler != null) {
                    try {
                        handler.leave(client, this);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while executing \"leave\" for client " + client + " on handler " + handler), (Throwable)e);
                    }
                }
            }
            this.removeEventListener(conn);
            this.connectionStats.decrement();
            if (this.equals(conn.getScope()) && (server = this.getServer()) instanceof Server) {
                ((Server)server).notifyDisconnected(conn);
            }
        }
        if (this.hasParent()) {
            this.parent.disconnect(conn);
        }
    }

    @Override
    public void dispatchEvent(IEvent event) {
        Iterator<IConnection> conns = this.getConnections();
        while (conns.hasNext()) {
            try {
                conns.next().dispatchEvent(event);
            }
            catch (RuntimeException e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public int getActiveClients() {
        return this.clients.size();
    }

    @Override
    public int getActiveConnections() {
        return this.connectionStats.getCurrent();
    }

    @Override
    public int getActiveSubscopes() {
        return this.subscopeStats.getCurrent();
    }

    @Override
    public IBasicScope getBasicScope(String type, String name) {
        return this.children.get(type + ":" + name);
    }

    @Override
    public Iterator<String> getBasicScopeNames(String type) {
        if (type == null) {
            return this.children.keySet().iterator();
        }
        return new PrefixFilteringStringIterator(this.children.keySet().iterator(), type + ":");
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Set<IClient> getClients() {
        return this.clients.keySet();
    }

    @Override
    public Iterator<IConnection> getConnections() {
        return new ConnectionIterator();
    }

    @Override
    public IContext getContext() {
        if (!this.hasContext() && this.hasParent()) {
            log.debug((Object)"returning parent context");
            return this.parent.getContext();
        }
        log.debug((Object)"returning context");
        return this.context;
    }

    @Override
    public String getContextPath() {
        if (this.hasContext()) {
            return "";
        }
        if (this.hasParent()) {
            return this.parent.getContextPath() + '/' + this.name;
        }
        return null;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getDepth() {
        if (this.depth == -1) {
            this.depth = this.hasParent() ? this.parent.getDepth() + 1 : 0;
        }
        return this.depth;
    }

    @Override
    public IScopeHandler getHandler() {
        if (this.handler != null) {
            return this.handler;
        }
        if (this.hasParent()) {
            return this.getParent().getHandler();
        }
        return null;
    }

    @Override
    public int getMaxClients() {
        return this.clientStats.getMax();
    }

    @Override
    public int getMaxConnections() {
        return this.connectionStats.getMax();
    }

    @Override
    public int getMaxSubscopes() {
        return this.subscopeStats.getMax();
    }

    @Override
    public IScope getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        if (this.hasParent()) {
            return this.parent.getPath() + '/' + this.parent.getName();
        }
        return "";
    }

    @Override
    public Resource getResource(String path) {
        if (this.hasContext()) {
            return this.context.getResource(path);
        }
        return this.getContext().getResource(this.getContextPath() + '/' + path);
    }

    @Override
    public Resource[] getResources(String path) throws IOException {
        if (this.hasContext()) {
            return this.context.getResources(path);
        }
        return this.getContext().getResources(this.getContextPath() + '/' + path);
    }

    @Override
    public IScope getScope(String name) {
        return (IScope)this.children.get("scope:" + name);
    }

    @Override
    public Iterator<String> getScopeNames() {
        return new PrefixFilteringStringIterator(this.children.keySet().iterator(), TYPE);
    }

    @Override
    public Object getServiceHandler(String name) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers == null) {
            return null;
        }
        return serviceHandlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers == null) {
            return Collections.EMPTY_SET;
        }
        return serviceHandlers.keySet();
    }

    protected Map<String, Object> getServiceHandlers() {
        return this.getServiceHandlers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getServiceHandlers(boolean allowCreate) {
        if (this.serviceHandlers == null) {
            if (!allowCreate) {
                return null;
            }
            Scope scope = this;
            synchronized (scope) {
                if (this.serviceHandlers == null) {
                    this.serviceHandlers = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.serviceHandlers;
    }

    @Override
    public IScopeStatistics getStatistics() {
        return this;
    }

    @Override
    public int getTotalClients() {
        return this.clientStats.getTotal();
    }

    @Override
    public int getTotalConnections() {
        return this.connectionStats.getTotal();
    }

    @Override
    public int getTotalSubscopes() {
        return this.subscopeStats.getTotal();
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return false;
    }

    @Override
    public boolean hasChildScope(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Has child scope? " + name + " in " + this));
        }
        return this.children.containsKey("scope:" + name);
    }

    @Override
    public boolean hasChildScope(String type, String name) {
        return this.children.containsKey(type + ":" + name);
    }

    @Override
    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public boolean hasHandler() {
        return this.handler != null || this.hasParent() && this.getParent().hasHandler();
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public void init() {
        if (this.hasParent() && !this.parent.hasChildScope(this.name) && !this.parent.addChildScope(this)) {
            return;
        }
        if (this.autoStart) {
            this.start();
        }
    }

    public void uninit() {
        for (IBasicScope child : this.children.values()) {
            if (!(child instanceof Scope)) continue;
            ((Scope)child).uninit();
        }
        this.stop();
        if (this.hasParent() && this.parent.hasChildScope(this.name)) {
            this.parent.removeChildScope(this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Iterator<IBasicScope> iterator() {
        return this.children.values().iterator();
    }

    @Override
    public Set<IConnection> lookupConnections(IClient client) {
        return this.clients.get(client);
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers();
        serviceHandlers.put(name, handler);
    }

    @Override
    public void removeChildScope(IBasicScope scope) {
        IServer server;
        if (scope instanceof IScope) {
            if (this.hasHandler()) {
                this.getHandler().stop((IScope)scope);
            }
            this.subscopeStats.decrement();
        }
        this.children.remove(scope.getType() + ":" + scope.getName());
        if (this.hasHandler()) {
            log.debug((Object)"Remove child scope");
            this.getHandler().removeChildScope(scope);
        }
        scope.setStore(null);
        if (scope instanceof IScope && (server = this.getServer()) instanceof Server) {
            ((Server)server).notifyScopeRemoved((IScope)scope);
        }
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public void setChildLoadPath(String pattern) {
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHandler(IScopeHandler handler) {
        this.handler = handler;
        if (handler instanceof IScopeAware) {
            ((IScopeAware)((Object)handler)).setScope(this);
        }
    }

    @Override
    public void setName(String name) {
        if (this.oName != null) {
            JMXAgent.unregisterMBean(this.oName);
            this.oName = null;
        }
        this.name = name;
        if (name != null) {
            try {
                this.oName = new ObjectName(JMXFactory.getDefaultDomain() + ":type=" + this.getClass().getName() + ",name=" + name);
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Invalid object name.", (Throwable)e);
            }
            JMXAgent.registerMBean((Object)this, this.getClass().getName(), ScopeMBean.class, this.oName);
        }
    }

    public void setParent(IScope parent) {
        this.parent = parent;
    }

    @Override
    public void setPersistenceClass(String persistenceClass) throws Exception {
        this.persistenceClass = persistenceClass;
        if (persistenceClass != null) {
            this.setStore(PersistenceUtils.getPersistenceStore(this, persistenceClass));
        } else {
            this.setStore(null);
        }
    }

    @Override
    public synchronized boolean start() {
        boolean result = false;
        if (this.enabled && !this.running) {
            if (this.hasHandler()) {
                try {
                    if (this.handler != null) {
                        result = this.handler.start(this);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Could not start scope " + this), e);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scope " + this + " has no handler, allowing start."));
                }
                result = true;
            }
            this.running = result;
        }
        return result;
    }

    @Override
    public synchronized void stop() {
        if (this.enabled && this.running && this.hasHandler()) {
            try {
                if (this.handler != null) {
                    this.handler.stop(this);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Could not stop scope " + this), e);
            }
        }
        this.running = false;
    }

    public String toString() {
        ToStringCreator tsc = new ToStringCreator((Object)this);
        return tsc.append("Depth", this.getDepth()).append("Path", (Object)this.getPath()).append("Name", (Object)this.getName()).toString();
    }

    @Override
    public void unregisterServiceHandler(String name) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers == null) {
            return;
        }
        serviceHandlers.remove(name);
    }

    public IServer getServer() {
        if (!this.hasParent()) {
            return null;
        }
        IScope parent = this.getParent();
        if (parent instanceof Scope) {
            return ((Scope)parent).getServer();
        }
        if (parent instanceof IGlobalScope) {
            return ((IGlobalScope)parent).getServer();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PrefixFilteringStringIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        private String next;
        private final String prefix;

        public PrefixFilteringStringIterator(Iterator<String> iterator, String prefix) {
            this.iterator = iterator;
            this.prefix = prefix;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            do {
                String string = this.next = this.iterator.hasNext() ? this.iterator.next() : null;
            } while (this.next != null && !this.next.startsWith(this.prefix));
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next != null) {
                String result = this.next;
                this.next = null;
                return result.substring(this.prefix.length());
            }
            if (this.hasNext()) {
                return this.next();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConnectionIterator
    implements Iterator<IConnection> {
        private Iterator<IConnection> connIterator;
        private IConnection current;
        private final Iterator<Set<IConnection>> setIterator;

        public ConnectionIterator() {
            this.setIterator = Scope.this.clients.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.connIterator != null && this.connIterator.hasNext()) {
                return true;
            }
            if (!this.setIterator.hasNext()) {
                return false;
            }
            this.connIterator = this.setIterator.next().iterator();
            while (this.connIterator != null) {
                if (this.connIterator.hasNext()) {
                    return true;
                }
                if (!this.setIterator.hasNext()) {
                    return false;
                }
                this.connIterator = this.setIterator.next().iterator();
            }
            return false;
        }

        @Override
        public IConnection next() {
            if (this.connIterator == null || !this.connIterator.hasNext()) {
                if (!this.setIterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.connIterator = this.setIterator.next().iterator();
                while (!this.connIterator.hasNext()) {
                    if (!this.setIterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.connIterator = this.setIterator.next().iterator();
                }
            }
            this.current = this.connIterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                Scope.this.disconnect(this.current);
            }
        }
    }
}

