/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IServer;
import org.red5.server.api.listeners.IConnectionListener;
import org.red5.server.api.listeners.IScopeListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer,
ApplicationContextAware {
    protected static Log log = LogFactory.getLog((String)Server.class.getName());
    protected ConcurrentHashMap<String, IGlobalScope> globals = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> mapping = new ConcurrentHashMap();
    protected ApplicationContext applicationContext;
    protected static final String SLASH = "/";
    protected static final String EMPTY = "";
    public Set<IScopeListener> scopeListeners = new CopyOnWriteArraySet<IScopeListener>();
    public Set<IConnectionListener> connectionListeners = new CopyOnWriteArraySet<IConnectionListener>();

    public void setApplicationContext(ApplicationContext applicationContext) {
        log.debug((Object)"Setting application context");
        this.applicationContext = applicationContext;
    }

    protected String getKey(String hostName, String contextPath) {
        if (hostName == null) {
            hostName = EMPTY;
        }
        if (contextPath == null) {
            contextPath = EMPTY;
        }
        return hostName + SLASH + contextPath;
    }

    @Override
    public IGlobalScope lookupGlobal(String hostName, String contextPath) {
        log.debug((Object)this);
        String key = this.getKey(hostName, contextPath);
        while (contextPath.indexOf(SLASH) != -1) {
            key = this.getKey(hostName, contextPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check: " + key));
            }
            if (this.mapping.containsKey(key)) {
                return this.getGlobal(this.mapping.get(key));
            }
            int slashIndex = contextPath.lastIndexOf(SLASH);
            contextPath = contextPath.substring(0, slashIndex);
        }
        key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check host and path: " + key));
        }
        if (this.mapping.containsKey(key)) {
            return this.getGlobal(this.mapping.get(key));
        }
        key = this.getKey(EMPTY, contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check wildcard host with path: " + key));
        }
        if (this.mapping.containsKey(key)) {
            return this.getGlobal(this.mapping.get(key));
        }
        key = this.getKey(hostName, EMPTY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check host with no path: " + key));
        }
        if (this.mapping.containsKey(key)) {
            return this.getGlobal(this.mapping.get(key));
        }
        key = this.getKey(EMPTY, EMPTY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check default host, default path: " + key));
        }
        return this.getGlobal(this.mapping.get(key));
    }

    @Override
    public IGlobalScope getGlobal(String name) {
        if (name == null) {
            return null;
        }
        return this.globals.get(name);
    }

    @Override
    public void registerGlobal(IGlobalScope scope) {
        log.info((Object)("Registering global scope: " + scope.getName()));
        this.globals.put(scope.getName(), scope);
    }

    @Override
    public boolean addMapping(String hostName, String contextPath, String globalName) {
        log.info((Object)("Add mapping global: " + globalName + " host: " + hostName + " context: " + contextPath));
        String key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add mapping: " + key + " => " + globalName));
        }
        if (this.mapping.containsKey(key)) {
            return false;
        }
        this.mapping.put(key, globalName);
        return true;
    }

    @Override
    public boolean removeMapping(String hostName, String contextPath) {
        log.info((Object)("Remove mapping host: " + hostName + " context: " + contextPath));
        String key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove mapping: " + key));
        }
        if (!this.mapping.containsKey(key)) {
            return false;
        }
        this.mapping.remove(key);
        return true;
    }

    @Override
    public Map<String, String> getMappingTable() {
        return this.mapping;
    }

    @Override
    public Iterator<String> getGlobalNames() {
        return this.globals.keySet().iterator();
    }

    @Override
    public Iterator<IGlobalScope> getGlobalScopes() {
        return this.globals.values().iterator();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append(this.mapping).toString();
    }

    @Override
    public void addListener(IScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    @Override
    public void addListener(IConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeListener(IScopeListener listener) {
        this.scopeListeners.remove(listener);
    }

    @Override
    public void removeListener(IConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void notifyScopeCreated(IScope scope) {
        for (IScopeListener listener : this.scopeListeners) {
            listener.notifyScopeCreated(scope);
        }
    }

    protected void notifyScopeRemoved(IScope scope) {
        for (IScopeListener listener : this.scopeListeners) {
            listener.notifyScopeRemoved(scope);
        }
    }

    protected void notifyConnected(IConnection conn) {
        for (IConnectionListener listener : this.connectionListeners) {
            listener.notifyConnected(conn);
        }
    }

    protected void notifyDisconnected(IConnection conn) {
        for (IConnectionListener listener : this.connectionListeners) {
            listener.notifyDisconnected(conn);
        }
    }
}

