/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class Standalone {
    protected static Log log = LogFactory.getLog((String)Standalone.class.getName());
    protected static String red5Config = "red5.xml";

    public static void raiseOriginalException(Throwable e) throws Throwable {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        throw e;
    }

    public static void main(String[] args) throws Throwable {
        String conf;
        if (args.length == 1) {
            red5Config = args[0];
        }
        long time = System.currentTimeMillis();
        log.info((Object)"RED5 Server (http://www.osflash.org/red5)");
        log.info((Object)("Loading red5 global context from: " + red5Config));
        String classpath = System.getProperty("java.class.path");
        String root = System.getProperty("red5.root");
        if (root != null) {
            conf = root + "/conf";
        } else {
            File fp = new File(red5Config);
            if (!(fp = fp.getCanonicalFile()).isFile()) {
                String[] paths;
                for (String element : paths = classpath.split(System.getProperty("path.separator"))) {
                    fp = new File(element + '/' + red5Config);
                    if ((fp = fp.getCanonicalFile()).isFile()) break;
                }
            }
            if (!fp.isFile()) {
                throw new Exception("could not find configuration file " + red5Config + " on your classpath " + classpath);
            }
            root = fp.getAbsolutePath();
            root = root.replace('\\', '/');
            int idx = root.lastIndexOf(47);
            conf = root.substring(0, idx);
            idx = conf.lastIndexOf(47);
            root = conf.substring(0, idx);
            if (System.getProperty("file.separator").equals("/")) {
                root = '/' + root;
            }
            System.setProperty("red5.root", root);
            log.info((Object)("Setting Red5 root to " + root));
        }
        System.setProperty("red5.config_root", conf);
        log.info((Object)("Setting configuation root to " + conf));
        Properties props = new Properties();
        props.load(new FileInputStream(conf + "/red5.properties"));
        for (Object o : props.keySet()) {
            String key = (String)o;
            if (key == null || key.equals("")) continue;
            System.setProperty(key, props.getProperty(key));
        }
        try {
            ContextSingletonBeanFactoryLocator.getInstance((String)red5Config).useBeanFactory("red5.common");
        }
        catch (Exception e) {
            Standalone.raiseOriginalException(e);
        }
        long startupIn = System.currentTimeMillis() - time;
        log.info((Object)("Startup done in: " + startupIn + " ms"));
    }
}

